/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MariaDBLinkedService
extends LinkedService {
    private String type = "MariaDB";
    private Object driverVersion;
    private Object connectionString;
    private Object server;
    private Object port;
    private Object username;
    private Object database;
    private Object sslMode;
    private Object useSystemTrustStore;
    private AzureKeyVaultSecretReference password;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getDriverVersion() {
        return this.driverVersion;
    }

    public MariaDBLinkedService setDriverVersion(Object driverVersion) {
        this.driverVersion = driverVersion;
        return this;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public MariaDBLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getServer() {
        return this.server;
    }

    public MariaDBLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public MariaDBLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public MariaDBLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public MariaDBLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getSslMode() {
        return this.sslMode;
    }

    public MariaDBLinkedService setSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public MariaDBLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public MariaDBLinkedService setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public MariaDBLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public MariaDBLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public MariaDBLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public MariaDBLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MariaDBLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public MariaDBLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.driverVersion != null || this.connectionString != null || this.server != null || this.port != null || this.username != null || this.database != null || this.sslMode != null || this.useSystemTrustStore != null || this.password != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.driverVersion != null) {
                jsonWriter.writeUntypedField("driverVersion", this.driverVersion);
            }
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            if (this.server != null) {
                jsonWriter.writeUntypedField("server", this.server);
            }
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            if (this.sslMode != null) {
                jsonWriter.writeUntypedField("sslMode", this.sslMode);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MariaDBLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (MariaDBLinkedService)jsonReader.readObject(reader -> {
            MariaDBLinkedService deserializedMariaDBLinkedService = new MariaDBLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedMariaDBLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedMariaDBLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMariaDBLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedMariaDBLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMariaDBLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMariaDBLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("driverVersion".equals(fieldName)) {
                            deserializedMariaDBLinkedService.driverVersion = reader.readUntyped();
                            continue;
                        }
                        if ("connectionString".equals(fieldName)) {
                            deserializedMariaDBLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("server".equals(fieldName)) {
                            deserializedMariaDBLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedMariaDBLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedMariaDBLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedMariaDBLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("sslMode".equals(fieldName)) {
                            deserializedMariaDBLinkedService.sslMode = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedMariaDBLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedMariaDBLinkedService.password = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedMariaDBLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMariaDBLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedMariaDBLinkedService;
        });
    }
}

