/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class LinkTableStatus
implements JsonSerializable<LinkTableStatus> {
    private String id;
    private String status;
    private String errorMessage;
    private Object startTime;
    private Object stopTime;
    private String linkTableId;
    private String errorCode;
    private OffsetDateTime lastProcessedData;
    private OffsetDateTime lastTransactionCommitTime;

    public String getId() {
        return this.id;
    }

    public LinkTableStatus setId(String id) {
        this.id = id;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public LinkTableStatus setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public LinkTableStatus setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public Object getStartTime() {
        return this.startTime;
    }

    public LinkTableStatus setStartTime(Object startTime) {
        this.startTime = startTime;
        return this;
    }

    public Object getStopTime() {
        return this.stopTime;
    }

    public LinkTableStatus setStopTime(Object stopTime) {
        this.stopTime = stopTime;
        return this;
    }

    public String getLinkTableId() {
        return this.linkTableId;
    }

    public LinkTableStatus setLinkTableId(String linkTableId) {
        this.linkTableId = linkTableId;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public LinkTableStatus setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public OffsetDateTime getLastProcessedData() {
        return this.lastProcessedData;
    }

    public LinkTableStatus setLastProcessedData(OffsetDateTime lastProcessedData) {
        this.lastProcessedData = lastProcessedData;
        return this;
    }

    public OffsetDateTime getLastTransactionCommitTime() {
        return this.lastTransactionCommitTime;
    }

    public LinkTableStatus setLastTransactionCommitTime(OffsetDateTime lastTransactionCommitTime) {
        this.lastTransactionCommitTime = lastTransactionCommitTime;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        if (this.startTime != null) {
            jsonWriter.writeUntypedField("startTime", this.startTime);
        }
        if (this.stopTime != null) {
            jsonWriter.writeUntypedField("stopTime", this.stopTime);
        }
        jsonWriter.writeStringField("linkTableId", this.linkTableId);
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("lastProcessedData", this.lastProcessedData == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastProcessedData));
        jsonWriter.writeStringField("lastTransactionCommitTime", this.lastTransactionCommitTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastTransactionCommitTime));
        return jsonWriter.writeEndObject();
    }

    public static LinkTableStatus fromJson(JsonReader jsonReader) throws IOException {
        return (LinkTableStatus)jsonReader.readObject(reader -> {
            LinkTableStatus deserializedLinkTableStatus = new LinkTableStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkTableStatus.id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedLinkTableStatus.status = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedLinkTableStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedLinkTableStatus.startTime = reader.readUntyped();
                    continue;
                }
                if ("stopTime".equals(fieldName)) {
                    deserializedLinkTableStatus.stopTime = reader.readUntyped();
                    continue;
                }
                if ("linkTableId".equals(fieldName)) {
                    deserializedLinkTableStatus.linkTableId = reader.getString();
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedLinkTableStatus.errorCode = reader.getString();
                    continue;
                }
                if ("lastProcessedData".equals(fieldName)) {
                    deserializedLinkTableStatus.lastProcessedData = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastTransactionCommitTime".equals(fieldName)) {
                    deserializedLinkTableStatus.lastTransactionCommitTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkTableStatus;
        });
    }
}

