/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.LinkTableRequestSource;
import com.azure.analytics.synapse.artifacts.models.LinkTableRequestTarget;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LinkTableResource
implements JsonSerializable<LinkTableResource> {
    private String id;
    private String name;
    private LinkTableRequestSource source;
    private LinkTableRequestTarget target;

    public String getId() {
        return this.id;
    }

    public LinkTableResource setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public LinkTableResource setName(String name) {
        this.name = name;
        return this;
    }

    public LinkTableRequestSource getSource() {
        return this.source;
    }

    public LinkTableResource setSource(LinkTableRequestSource source) {
        this.source = source;
        return this;
    }

    public LinkTableRequestTarget getTarget() {
        return this.target;
    }

    public LinkTableResource setTarget(LinkTableRequestTarget target) {
        this.target = target;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        return jsonWriter.writeEndObject();
    }

    public static LinkTableResource fromJson(JsonReader jsonReader) throws IOException {
        return (LinkTableResource)jsonReader.readObject(reader -> {
            LinkTableResource deserializedLinkTableResource = new LinkTableResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkTableResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLinkTableResource.name = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedLinkTableResource.source = LinkTableRequestSource.fromJson(reader);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedLinkTableResource.target = LinkTableRequestTarget.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkTableResource;
        });
    }
}

