/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.LinkConnectionRefreshStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class LinkConnectionDetailedStatus
implements JsonSerializable<LinkConnectionDetailedStatus> {
    private String id;
    private String name;
    private Boolean isApplyingChanges;
    private Boolean isPartiallyFailed;
    private Object startTime;
    private Object stopTime;
    private String status;
    private String continuousRunId;
    private Object error;
    private LinkConnectionRefreshStatus refreshStatus;
    private OffsetDateTime landingZoneCredentialExpireTime;

    public String getId() {
        return this.id;
    }

    public LinkConnectionDetailedStatus setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public LinkConnectionDetailedStatus setName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isApplyingChanges() {
        return this.isApplyingChanges;
    }

    public LinkConnectionDetailedStatus setIsApplyingChanges(Boolean isApplyingChanges) {
        this.isApplyingChanges = isApplyingChanges;
        return this;
    }

    public Boolean isPartiallyFailed() {
        return this.isPartiallyFailed;
    }

    public LinkConnectionDetailedStatus setIsPartiallyFailed(Boolean isPartiallyFailed) {
        this.isPartiallyFailed = isPartiallyFailed;
        return this;
    }

    public Object getStartTime() {
        return this.startTime;
    }

    public LinkConnectionDetailedStatus setStartTime(Object startTime) {
        this.startTime = startTime;
        return this;
    }

    public Object getStopTime() {
        return this.stopTime;
    }

    public LinkConnectionDetailedStatus setStopTime(Object stopTime) {
        this.stopTime = stopTime;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public LinkConnectionDetailedStatus setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getContinuousRunId() {
        return this.continuousRunId;
    }

    public LinkConnectionDetailedStatus setContinuousRunId(String continuousRunId) {
        this.continuousRunId = continuousRunId;
        return this;
    }

    public Object getError() {
        return this.error;
    }

    public LinkConnectionDetailedStatus setError(Object error) {
        this.error = error;
        return this;
    }

    public LinkConnectionRefreshStatus getRefreshStatus() {
        return this.refreshStatus;
    }

    public LinkConnectionDetailedStatus setRefreshStatus(LinkConnectionRefreshStatus refreshStatus) {
        this.refreshStatus = refreshStatus;
        return this;
    }

    public OffsetDateTime getLandingZoneCredentialExpireTime() {
        return this.landingZoneCredentialExpireTime;
    }

    public LinkConnectionDetailedStatus setLandingZoneCredentialExpireTime(OffsetDateTime landingZoneCredentialExpireTime) {
        this.landingZoneCredentialExpireTime = landingZoneCredentialExpireTime;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isApplyingChanges", this.isApplyingChanges);
        jsonWriter.writeBooleanField("isPartiallyFailed", this.isPartiallyFailed);
        if (this.startTime != null) {
            jsonWriter.writeUntypedField("startTime", this.startTime);
        }
        if (this.stopTime != null) {
            jsonWriter.writeUntypedField("stopTime", this.stopTime);
        }
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("continuousRunId", this.continuousRunId);
        if (this.error != null) {
            jsonWriter.writeUntypedField("error", this.error);
        }
        jsonWriter.writeJsonField("refreshStatus", (JsonSerializable)this.refreshStatus);
        jsonWriter.writeStringField("landingZoneCredentialExpireTime", this.landingZoneCredentialExpireTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.landingZoneCredentialExpireTime));
        return jsonWriter.writeEndObject();
    }

    public static LinkConnectionDetailedStatus fromJson(JsonReader jsonReader) throws IOException {
        return (LinkConnectionDetailedStatus)jsonReader.readObject(reader -> {
            LinkConnectionDetailedStatus deserializedLinkConnectionDetailedStatus = new LinkConnectionDetailedStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.name = reader.getString();
                    continue;
                }
                if ("isApplyingChanges".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.isApplyingChanges = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isPartiallyFailed".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.isPartiallyFailed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.startTime = reader.readUntyped();
                    continue;
                }
                if ("stopTime".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.stopTime = reader.readUntyped();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.status = reader.getString();
                    continue;
                }
                if ("continuousRunId".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.continuousRunId = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.error = reader.readUntyped();
                    continue;
                }
                if ("refreshStatus".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.refreshStatus = LinkConnectionRefreshStatus.fromJson(reader);
                    continue;
                }
                if ("landingZoneCredentialExpireTime".equals(fieldName)) {
                    deserializedLinkConnectionDetailedStatus.landingZoneCredentialExpireTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkConnectionDetailedStatus;
        });
    }
}

