/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.LibraryResourceProperties;
import com.azure.analytics.synapse.artifacts.models.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class LibraryResource
extends SubResource {
    private LibraryResourceProperties properties;
    private String etag;
    private String type;
    private String name;
    private String id;

    public LibraryResourceProperties getProperties() {
        return this.properties;
    }

    public LibraryResource setProperties(LibraryResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static LibraryResource fromJson(JsonReader jsonReader) throws IOException {
        return (LibraryResource)jsonReader.readObject(reader -> {
            LibraryResource deserializedLibraryResource = new LibraryResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLibraryResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedLibraryResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLibraryResource.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedLibraryResource.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLibraryResource.properties = LibraryResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLibraryResource;
        });
    }
}

