/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class LibraryInfo
implements JsonSerializable<LibraryInfo> {
    private String name;
    private String path;
    private String containerName;
    private OffsetDateTime uploadedTimestamp;
    private String type;
    private String provisioningStatus;
    private String creatorId;

    public String getName() {
        return this.name;
    }

    public LibraryInfo setName(String name) {
        this.name = name;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public LibraryInfo setPath(String path) {
        this.path = path;
        return this;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public LibraryInfo setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public OffsetDateTime getUploadedTimestamp() {
        return this.uploadedTimestamp;
    }

    public LibraryInfo setUploadedTimestamp(OffsetDateTime uploadedTimestamp) {
        this.uploadedTimestamp = uploadedTimestamp;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public LibraryInfo setType(String type) {
        this.type = type;
        return this;
    }

    public String getProvisioningStatus() {
        return this.provisioningStatus;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("uploadedTimestamp", this.uploadedTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.uploadedTimestamp));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static LibraryInfo fromJson(JsonReader jsonReader) throws IOException {
        return (LibraryInfo)jsonReader.readObject(reader -> {
            LibraryInfo deserializedLibraryInfo = new LibraryInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLibraryInfo.name = reader.getString();
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedLibraryInfo.path = reader.getString();
                    continue;
                }
                if ("containerName".equals(fieldName)) {
                    deserializedLibraryInfo.containerName = reader.getString();
                    continue;
                }
                if ("uploadedTimestamp".equals(fieldName)) {
                    deserializedLibraryInfo.uploadedTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLibraryInfo.type = reader.getString();
                    continue;
                }
                if ("provisioningStatus".equals(fieldName)) {
                    deserializedLibraryInfo.provisioningStatus = reader.getString();
                    continue;
                }
                if ("creatorId".equals(fieldName)) {
                    deserializedLibraryInfo.creatorId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLibraryInfo;
        });
    }
}

