/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.MetadataItem;
import com.azure.analytics.synapse.artifacts.models.StoreWriteSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class LakeHouseWriteSettings
extends StoreWriteSettings {
    private String type = "LakeHouseWriteSettings";

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public LakeHouseWriteSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public LakeHouseWriteSettings setCopyBehavior(Object copyBehavior) {
        super.setCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public LakeHouseWriteSettings setMetadata(List<MetadataItem> metadata) {
        super.setMetadata(metadata);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getCopyBehavior() != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.getCopyBehavior());
        }
        jsonWriter.writeArrayField("metadata", this.getMetadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LakeHouseWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (LakeHouseWriteSettings)jsonReader.readObject(reader -> {
            LakeHouseWriteSettings deserializedLakeHouseWriteSettings = new LakeHouseWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedLakeHouseWriteSettings.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedLakeHouseWriteSettings.setCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedLakeHouseWriteSettings.setMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLakeHouseWriteSettings.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedLakeHouseWriteSettings.setAdditionalProperties(additionalProperties);
            return deserializedLakeHouseWriteSettings;
        });
    }
}

