/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LakeHouseTableSource
extends CopySource {
    private String type = "LakeHouseTableSource";
    private Object timestampAsOf;
    private Object versionAsOf;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTimestampAsOf() {
        return this.timestampAsOf;
    }

    public LakeHouseTableSource setTimestampAsOf(Object timestampAsOf) {
        this.timestampAsOf = timestampAsOf;
        return this;
    }

    public Object getVersionAsOf() {
        return this.versionAsOf;
    }

    public LakeHouseTableSource setVersionAsOf(Object versionAsOf) {
        this.versionAsOf = versionAsOf;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public LakeHouseTableSource setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public LakeHouseTableSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public LakeHouseTableSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public LakeHouseTableSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.timestampAsOf != null) {
            jsonWriter.writeUntypedField("timestampAsOf", this.timestampAsOf);
        }
        if (this.versionAsOf != null) {
            jsonWriter.writeUntypedField("versionAsOf", this.versionAsOf);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LakeHouseTableSource fromJson(JsonReader jsonReader) throws IOException {
        return (LakeHouseTableSource)jsonReader.readObject(reader -> {
            LakeHouseTableSource deserializedLakeHouseTableSource = new LakeHouseTableSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedLakeHouseTableSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedLakeHouseTableSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedLakeHouseTableSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLakeHouseTableSource.type = reader.getString();
                    continue;
                }
                if ("timestampAsOf".equals(fieldName)) {
                    deserializedLakeHouseTableSource.timestampAsOf = reader.readUntyped();
                    continue;
                }
                if ("versionAsOf".equals(fieldName)) {
                    deserializedLakeHouseTableSource.versionAsOf = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedLakeHouseTableSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedLakeHouseTableSource.setAdditionalProperties(additionalProperties);
            return deserializedLakeHouseTableSource;
        });
    }
}

