/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JsonFormat
extends DatasetStorageFormat {
    private String type = "JsonFormat";
    private Object filePattern;
    private Object nestingSeparator;
    private Object encodingName;
    private Object jsonNodeReference;
    private Object jsonPathDefinition;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFilePattern() {
        return this.filePattern;
    }

    public JsonFormat setFilePattern(Object filePattern) {
        this.filePattern = filePattern;
        return this;
    }

    public Object getNestingSeparator() {
        return this.nestingSeparator;
    }

    public JsonFormat setNestingSeparator(Object nestingSeparator) {
        this.nestingSeparator = nestingSeparator;
        return this;
    }

    public Object getEncodingName() {
        return this.encodingName;
    }

    public JsonFormat setEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    public Object getJsonNodeReference() {
        return this.jsonNodeReference;
    }

    public JsonFormat setJsonNodeReference(Object jsonNodeReference) {
        this.jsonNodeReference = jsonNodeReference;
        return this;
    }

    public Object getJsonPathDefinition() {
        return this.jsonPathDefinition;
    }

    public JsonFormat setJsonPathDefinition(Object jsonPathDefinition) {
        this.jsonPathDefinition = jsonPathDefinition;
        return this;
    }

    @Override
    public JsonFormat setSerializer(Object serializer) {
        super.setSerializer(serializer);
        return this;
    }

    @Override
    public JsonFormat setDeserializer(Object deserializer) {
        super.setDeserializer(deserializer);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSerializer() != null) {
            jsonWriter.writeUntypedField("serializer", this.getSerializer());
        }
        if (this.getDeserializer() != null) {
            jsonWriter.writeUntypedField("deserializer", this.getDeserializer());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.filePattern != null) {
            jsonWriter.writeUntypedField("filePattern", this.filePattern);
        }
        if (this.nestingSeparator != null) {
            jsonWriter.writeUntypedField("nestingSeparator", this.nestingSeparator);
        }
        if (this.encodingName != null) {
            jsonWriter.writeUntypedField("encodingName", this.encodingName);
        }
        if (this.jsonNodeReference != null) {
            jsonWriter.writeUntypedField("jsonNodeReference", this.jsonNodeReference);
        }
        if (this.jsonPathDefinition != null) {
            jsonWriter.writeUntypedField("jsonPathDefinition", this.jsonPathDefinition);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static JsonFormat fromJson(JsonReader jsonReader) throws IOException {
        return (JsonFormat)jsonReader.readObject(reader -> {
            JsonFormat deserializedJsonFormat = new JsonFormat();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serializer".equals(fieldName)) {
                    deserializedJsonFormat.setSerializer(reader.readUntyped());
                    continue;
                }
                if ("deserializer".equals(fieldName)) {
                    deserializedJsonFormat.setDeserializer(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJsonFormat.type = reader.getString();
                    continue;
                }
                if ("filePattern".equals(fieldName)) {
                    deserializedJsonFormat.filePattern = reader.readUntyped();
                    continue;
                }
                if ("nestingSeparator".equals(fieldName)) {
                    deserializedJsonFormat.nestingSeparator = reader.readUntyped();
                    continue;
                }
                if ("encodingName".equals(fieldName)) {
                    deserializedJsonFormat.encodingName = reader.readUntyped();
                    continue;
                }
                if ("jsonNodeReference".equals(fieldName)) {
                    deserializedJsonFormat.jsonNodeReference = reader.readUntyped();
                    continue;
                }
                if ("jsonPathDefinition".equals(fieldName)) {
                    deserializedJsonFormat.jsonPathDefinition = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedJsonFormat.setAdditionalProperties(additionalProperties);
            return deserializedJsonFormat;
        });
    }
}

