/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JiraSource
extends TabularSource {
    private String type = "JiraSource";
    private Object query;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public JiraSource setQuery(Object query) {
        this.query = query;
        return this;
    }

    @Override
    public JiraSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public JiraSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public JiraSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public JiraSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public JiraSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static JiraSource fromJson(JsonReader jsonReader) throws IOException {
        return (JiraSource)jsonReader.readObject(reader -> {
            JiraSource deserializedJiraSource = new JiraSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedJiraSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedJiraSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedJiraSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedJiraSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedJiraSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJiraSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedJiraSource.query = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedJiraSource.setAdditionalProperties(additionalProperties);
            return deserializedJiraSource;
        });
    }
}

