/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.StoreReadSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HttpReadSettings
extends StoreReadSettings {
    private String type = "HttpReadSettings";
    private Object requestMethod;
    private Object requestBody;
    private Object additionalHeaders;
    private Object requestTimeout;
    private Object enablePartitionDiscovery;
    private Object partitionRootPath;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getRequestMethod() {
        return this.requestMethod;
    }

    public HttpReadSettings setRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public HttpReadSettings setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Object getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public HttpReadSettings setAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public Object getRequestTimeout() {
        return this.requestTimeout;
    }

    public HttpReadSettings setRequestTimeout(Object requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public Object getEnablePartitionDiscovery() {
        return this.enablePartitionDiscovery;
    }

    public HttpReadSettings setEnablePartitionDiscovery(Object enablePartitionDiscovery) {
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        return this;
    }

    public Object getPartitionRootPath() {
        return this.partitionRootPath;
    }

    public HttpReadSettings setPartitionRootPath(Object partitionRootPath) {
        this.partitionRootPath = partitionRootPath;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public HttpReadSettings setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public HttpReadSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.requestMethod != null) {
            jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
        }
        if (this.requestBody != null) {
            jsonWriter.writeUntypedField("requestBody", this.requestBody);
        }
        if (this.additionalHeaders != null) {
            jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
        }
        if (this.requestTimeout != null) {
            jsonWriter.writeUntypedField("requestTimeout", this.requestTimeout);
        }
        if (this.enablePartitionDiscovery != null) {
            jsonWriter.writeUntypedField("enablePartitionDiscovery", this.enablePartitionDiscovery);
        }
        if (this.partitionRootPath != null) {
            jsonWriter.writeUntypedField("partitionRootPath", this.partitionRootPath);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HttpReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (HttpReadSettings)jsonReader.readObject(reader -> {
            HttpReadSettings deserializedHttpReadSettings = new HttpReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedHttpReadSettings.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHttpReadSettings.type = reader.getString();
                    continue;
                }
                if ("requestMethod".equals(fieldName)) {
                    deserializedHttpReadSettings.requestMethod = reader.readUntyped();
                    continue;
                }
                if ("requestBody".equals(fieldName)) {
                    deserializedHttpReadSettings.requestBody = reader.readUntyped();
                    continue;
                }
                if ("additionalHeaders".equals(fieldName)) {
                    deserializedHttpReadSettings.additionalHeaders = reader.readUntyped();
                    continue;
                }
                if ("requestTimeout".equals(fieldName)) {
                    deserializedHttpReadSettings.requestTimeout = reader.readUntyped();
                    continue;
                }
                if ("enablePartitionDiscovery".equals(fieldName)) {
                    deserializedHttpReadSettings.enablePartitionDiscovery = reader.readUntyped();
                    continue;
                }
                if ("partitionRootPath".equals(fieldName)) {
                    deserializedHttpReadSettings.partitionRootPath = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedHttpReadSettings.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHttpReadSettings.setAdditionalProperties(additionalProperties);
            return deserializedHttpReadSettings;
        });
    }
}

