/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.HttpAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpLinkedService
extends LinkedService {
    private String type = "HttpServer";
    private Object url;
    private HttpAuthenticationType authenticationType;
    private Object userName;
    private SecretBase password;
    private Object embeddedCertData;
    private Object certThumbprint;
    private Object encryptedCredential;
    private Object enableServerCertificateValidation;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUrl() {
        return this.url;
    }

    public HttpLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public HttpAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public HttpLinkedService setAuthenticationType(HttpAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public HttpLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public HttpLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getEmbeddedCertData() {
        return this.embeddedCertData;
    }

    public HttpLinkedService setEmbeddedCertData(Object embeddedCertData) {
        this.embeddedCertData = embeddedCertData;
        return this;
    }

    public Object getCertThumbprint() {
        return this.certThumbprint;
    }

    public HttpLinkedService setCertThumbprint(Object certThumbprint) {
        this.certThumbprint = certThumbprint;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public HttpLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getEnableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public HttpLinkedService setEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    @Override
    public HttpLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public HttpLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public HttpLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HttpLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public HttpLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.url != null || this.authenticationType != null || this.userName != null || this.password != null || this.embeddedCertData != null || this.certThumbprint != null || this.encryptedCredential != null || this.enableServerCertificateValidation != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("url", this.url);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.embeddedCertData != null) {
                jsonWriter.writeUntypedField("embeddedCertData", this.embeddedCertData);
            }
            if (this.certThumbprint != null) {
                jsonWriter.writeUntypedField("certThumbprint", this.certThumbprint);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.enableServerCertificateValidation != null) {
                jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HttpLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (HttpLinkedService)jsonReader.readObject(reader -> {
            HttpLinkedService deserializedHttpLinkedService = new HttpLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedHttpLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedHttpLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHttpLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedHttpLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedHttpLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHttpLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("url".equals(fieldName)) {
                            deserializedHttpLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedHttpLinkedService.authenticationType = HttpAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedHttpLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedHttpLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("embeddedCertData".equals(fieldName)) {
                            deserializedHttpLinkedService.embeddedCertData = reader.readUntyped();
                            continue;
                        }
                        if ("certThumbprint".equals(fieldName)) {
                            deserializedHttpLinkedService.certThumbprint = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedHttpLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("enableServerCertificateValidation".equals(fieldName)) {
                            deserializedHttpLinkedService.enableServerCertificateValidation = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHttpLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedHttpLinkedService;
        });
    }
}

