/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.HDInsightClusterAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HDInsightLinkedService
extends LinkedService {
    private String type = "HDInsight";
    private Object clusterUri;
    private HDInsightClusterAuthenticationType clusterAuthType;
    private Object userName;
    private SecretBase password;
    private LinkedServiceReference linkedServiceName;
    private LinkedServiceReference hcatalogLinkedServiceName;
    private Object encryptedCredential;
    private Object isEspEnabled;
    private Object fileSystem;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getClusterUri() {
        return this.clusterUri;
    }

    public HDInsightLinkedService setClusterUri(Object clusterUri) {
        this.clusterUri = clusterUri;
        return this;
    }

    public HDInsightClusterAuthenticationType getClusterAuthType() {
        return this.clusterAuthType;
    }

    public HDInsightLinkedService setClusterAuthType(HDInsightClusterAuthenticationType clusterAuthType) {
        this.clusterAuthType = clusterAuthType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public HDInsightLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public HDInsightLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public LinkedServiceReference getLinkedServiceName() {
        return this.linkedServiceName;
    }

    public HDInsightLinkedService setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public LinkedServiceReference getHcatalogLinkedServiceName() {
        return this.hcatalogLinkedServiceName;
    }

    public HDInsightLinkedService setHcatalogLinkedServiceName(LinkedServiceReference hcatalogLinkedServiceName) {
        this.hcatalogLinkedServiceName = hcatalogLinkedServiceName;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public HDInsightLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getIsEspEnabled() {
        return this.isEspEnabled;
    }

    public HDInsightLinkedService setIsEspEnabled(Object isEspEnabled) {
        this.isEspEnabled = isEspEnabled;
        return this;
    }

    public Object getFileSystem() {
        return this.fileSystem;
    }

    public HDInsightLinkedService setFileSystem(Object fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public HDInsightLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public HDInsightLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public HDInsightLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public HDInsightLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public HDInsightLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public HDInsightLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.clusterUri != null || this.clusterAuthType != null || this.userName != null || this.password != null || this.linkedServiceName != null || this.hcatalogLinkedServiceName != null || this.encryptedCredential != null || this.isEspEnabled != null || this.fileSystem != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("clusterUri", this.clusterUri);
            jsonWriter.writeStringField("clusterAuthType", this.clusterAuthType == null ? null : this.clusterAuthType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
            jsonWriter.writeJsonField("hcatalogLinkedServiceName", (JsonSerializable)this.hcatalogLinkedServiceName);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.isEspEnabled != null) {
                jsonWriter.writeUntypedField("isEspEnabled", this.isEspEnabled);
            }
            if (this.fileSystem != null) {
                jsonWriter.writeUntypedField("fileSystem", this.fileSystem);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightLinkedService)jsonReader.readObject(reader -> {
            HDInsightLinkedService deserializedHDInsightLinkedService = new HDInsightLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedHDInsightLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedHDInsightLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedHDInsightLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedHDInsightLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("clusterUri".equals(fieldName)) {
                            deserializedHDInsightLinkedService.clusterUri = reader.readUntyped();
                            continue;
                        }
                        if ("clusterAuthType".equals(fieldName)) {
                            deserializedHDInsightLinkedService.clusterAuthType = HDInsightClusterAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedHDInsightLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedHDInsightLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("linkedServiceName".equals(fieldName)) {
                            deserializedHDInsightLinkedService.linkedServiceName = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("hcatalogLinkedServiceName".equals(fieldName)) {
                            deserializedHDInsightLinkedService.hcatalogLinkedServiceName = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedHDInsightLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("isEspEnabled".equals(fieldName)) {
                            deserializedHDInsightLinkedService.isEspEnabled = reader.readUntyped();
                            continue;
                        }
                        if ("fileSystem".equals(fieldName)) {
                            deserializedHDInsightLinkedService.fileSystem = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedHDInsightLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedHDInsightLinkedService;
        });
    }
}

