/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.GoogleBigQueryAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GoogleBigQueryLinkedService
extends LinkedService {
    private String type = "GoogleBigQuery";
    private Object project;
    private Object additionalProjects;
    private Object requestGoogleDriveScope;
    private GoogleBigQueryAuthenticationType authenticationType;
    private SecretBase refreshToken;
    private Object clientId;
    private SecretBase clientSecret;
    private Object email;
    private Object keyFilePath;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getProject() {
        return this.project;
    }

    public GoogleBigQueryLinkedService setProject(Object project) {
        this.project = project;
        return this;
    }

    public Object getAdditionalProjects() {
        return this.additionalProjects;
    }

    public GoogleBigQueryLinkedService setAdditionalProjects(Object additionalProjects) {
        this.additionalProjects = additionalProjects;
        return this;
    }

    public Object getRequestGoogleDriveScope() {
        return this.requestGoogleDriveScope;
    }

    public GoogleBigQueryLinkedService setRequestGoogleDriveScope(Object requestGoogleDriveScope) {
        this.requestGoogleDriveScope = requestGoogleDriveScope;
        return this;
    }

    public GoogleBigQueryAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public GoogleBigQueryLinkedService setAuthenticationType(GoogleBigQueryAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public SecretBase getRefreshToken() {
        return this.refreshToken;
    }

    public GoogleBigQueryLinkedService setRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public GoogleBigQueryLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public GoogleBigQueryLinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getEmail() {
        return this.email;
    }

    public GoogleBigQueryLinkedService setEmail(Object email) {
        this.email = email;
        return this;
    }

    public Object getKeyFilePath() {
        return this.keyFilePath;
    }

    public GoogleBigQueryLinkedService setKeyFilePath(Object keyFilePath) {
        this.keyFilePath = keyFilePath;
        return this;
    }

    public Object getTrustedCertPath() {
        return this.trustedCertPath;
    }

    public GoogleBigQueryLinkedService setTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public GoogleBigQueryLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public GoogleBigQueryLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public GoogleBigQueryLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.project != null || this.additionalProjects != null || this.requestGoogleDriveScope != null || this.authenticationType != null || this.refreshToken != null || this.clientId != null || this.clientSecret != null || this.email != null || this.keyFilePath != null || this.trustedCertPath != null || this.useSystemTrustStore != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("project", this.project);
            if (this.additionalProjects != null) {
                jsonWriter.writeUntypedField("additionalProjects", this.additionalProjects);
            }
            if (this.requestGoogleDriveScope != null) {
                jsonWriter.writeUntypedField("requestGoogleDriveScope", this.requestGoogleDriveScope);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.email != null) {
                jsonWriter.writeUntypedField("email", this.email);
            }
            if (this.keyFilePath != null) {
                jsonWriter.writeUntypedField("keyFilePath", this.keyFilePath);
            }
            if (this.trustedCertPath != null) {
                jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GoogleBigQueryLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (GoogleBigQueryLinkedService)jsonReader.readObject(reader -> {
            GoogleBigQueryLinkedService deserializedGoogleBigQueryLinkedService = new GoogleBigQueryLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedGoogleBigQueryLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedGoogleBigQueryLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGoogleBigQueryLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("project".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.project = reader.readUntyped();
                            continue;
                        }
                        if ("additionalProjects".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.additionalProjects = reader.readUntyped();
                            continue;
                        }
                        if ("requestGoogleDriveScope".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.requestGoogleDriveScope = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.authenticationType = GoogleBigQueryAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("refreshToken".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.refreshToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("email".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.email = reader.readUntyped();
                            continue;
                        }
                        if ("keyFilePath".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.keyFilePath = reader.readUntyped();
                            continue;
                        }
                        if ("trustedCertPath".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.trustedCertPath = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedGoogleBigQueryLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGoogleBigQueryLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedGoogleBigQueryLinkedService;
        });
    }
}

