/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.FormatReadSettings;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.StoreReadSettings;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GetMetadataActivity
extends ExecutionActivity {
    private String type = "GetMetadata";
    private DatasetReference dataset;
    private List<Object> fieldList;
    private StoreReadSettings storeSettings;
    private FormatReadSettings formatSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public DatasetReference getDataset() {
        return this.dataset;
    }

    public GetMetadataActivity setDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public List<Object> getFieldList() {
        return this.fieldList;
    }

    public GetMetadataActivity setFieldList(List<Object> fieldList) {
        this.fieldList = fieldList;
        return this;
    }

    public StoreReadSettings getStoreSettings() {
        return this.storeSettings;
    }

    public GetMetadataActivity setStoreSettings(StoreReadSettings storeSettings) {
        this.storeSettings = storeSettings;
        return this;
    }

    public FormatReadSettings getFormatSettings() {
        return this.formatSettings;
    }

    public GetMetadataActivity setFormatSettings(FormatReadSettings formatSettings) {
        this.formatSettings = formatSettings;
        return this;
    }

    @Override
    public GetMetadataActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public GetMetadataActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public GetMetadataActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public GetMetadataActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public GetMetadataActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public GetMetadataActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public GetMetadataActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public GetMetadataActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.dataset != null || this.fieldList != null || this.storeSettings != null || this.formatSettings != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
            jsonWriter.writeArrayField("fieldList", this.fieldList, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeJsonField("storeSettings", (JsonSerializable)this.storeSettings);
            jsonWriter.writeJsonField("formatSettings", (JsonSerializable)this.formatSettings);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GetMetadataActivity fromJson(JsonReader jsonReader) throws IOException {
        return (GetMetadataActivity)jsonReader.readObject(reader -> {
            GetMetadataActivity deserializedGetMetadataActivity = new GetMetadataActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGetMetadataActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGetMetadataActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedGetMetadataActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedGetMetadataActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedGetMetadataActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedGetMetadataActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedGetMetadataActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedGetMetadataActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGetMetadataActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("dataset".equals(fieldName)) {
                            deserializedGetMetadataActivity.dataset = DatasetReference.fromJson(reader);
                            continue;
                        }
                        if ("fieldList".equals(fieldName)) {
                            List fieldList;
                            deserializedGetMetadataActivity.fieldList = fieldList = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("storeSettings".equals(fieldName)) {
                            deserializedGetMetadataActivity.storeSettings = StoreReadSettings.fromJson(reader);
                            continue;
                        }
                        if ("formatSettings".equals(fieldName)) {
                            deserializedGetMetadataActivity.formatSettings = FormatReadSettings.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGetMetadataActivity.setAdditionalProperties(additionalProperties);
            return deserializedGetMetadataActivity;
        });
    }
}

