/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.Expression;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ForEachActivity
extends ControlActivity {
    private String type = "ForEach";
    private Boolean isSequential;
    private Integer batchCount;
    private Expression items;
    private List<Activity> activities;

    @Override
    public String getType() {
        return this.type;
    }

    public Boolean isSequential() {
        return this.isSequential;
    }

    public ForEachActivity setIsSequential(Boolean isSequential) {
        this.isSequential = isSequential;
        return this;
    }

    public Integer getBatchCount() {
        return this.batchCount;
    }

    public ForEachActivity setBatchCount(Integer batchCount) {
        this.batchCount = batchCount;
        return this;
    }

    public Expression getItems() {
        return this.items;
    }

    public ForEachActivity setItems(Expression items) {
        this.items = items;
        return this;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public ForEachActivity setActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    @Override
    public ForEachActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ForEachActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ForEachActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ForEachActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ForEachActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ForEachActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.isSequential != null || this.batchCount != null || this.items != null || this.activities != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeBooleanField("isSequential", this.isSequential);
            jsonWriter.writeNumberField("batchCount", (Number)this.batchCount);
            jsonWriter.writeJsonField("items", (JsonSerializable)this.items);
            jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ForEachActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ForEachActivity)jsonReader.readObject(reader -> {
            ForEachActivity deserializedForEachActivity = new ForEachActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedForEachActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedForEachActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedForEachActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedForEachActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedForEachActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedForEachActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedForEachActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("isSequential".equals(fieldName)) {
                            deserializedForEachActivity.isSequential = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("batchCount".equals(fieldName)) {
                            deserializedForEachActivity.batchCount = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        if ("items".equals(fieldName)) {
                            deserializedForEachActivity.items = Expression.fromJson(reader);
                            continue;
                        }
                        if ("activities".equals(fieldName)) {
                            List activities;
                            deserializedForEachActivity.activities = activities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedForEachActivity.setAdditionalProperties(additionalProperties);
            return deserializedForEachActivity;
        });
    }
}

