/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetCompression;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FileShareDataset
extends Dataset {
    private String type = "FileShare";
    private Object folderPath;
    private Object fileName;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private DatasetStorageFormat format;
    private Object fileFilter;
    private DatasetCompression compression;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFolderPath() {
        return this.folderPath;
    }

    public FileShareDataset setFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object getFileName() {
        return this.fileName;
    }

    public FileShareDataset setFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public Object getModifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public FileShareDataset setModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object getModifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public FileShareDataset setModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public DatasetStorageFormat getFormat() {
        return this.format;
    }

    public FileShareDataset setFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public Object getFileFilter() {
        return this.fileFilter;
    }

    public FileShareDataset setFileFilter(Object fileFilter) {
        this.fileFilter = fileFilter;
        return this;
    }

    public DatasetCompression getCompression() {
        return this.compression;
    }

    public FileShareDataset setCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public FileShareDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public FileShareDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public FileShareDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public FileShareDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public FileShareDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public FileShareDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public FileShareDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.folderPath != null || this.fileName != null || this.modifiedDatetimeStart != null || this.modifiedDatetimeEnd != null || this.format != null || this.fileFilter != null || this.compression != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.folderPath != null) {
                jsonWriter.writeUntypedField("folderPath", this.folderPath);
            }
            if (this.fileName != null) {
                jsonWriter.writeUntypedField("fileName", this.fileName);
            }
            if (this.modifiedDatetimeStart != null) {
                jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
            }
            if (this.modifiedDatetimeEnd != null) {
                jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
            }
            jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
            if (this.fileFilter != null) {
                jsonWriter.writeUntypedField("fileFilter", this.fileFilter);
            }
            jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static FileShareDataset fromJson(JsonReader jsonReader) throws IOException {
        return (FileShareDataset)jsonReader.readObject(reader -> {
            FileShareDataset deserializedFileShareDataset = new FileShareDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedFileShareDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedFileShareDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedFileShareDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedFileShareDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedFileShareDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedFileShareDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedFileShareDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFileShareDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("folderPath".equals(fieldName)) {
                            deserializedFileShareDataset.folderPath = reader.readUntyped();
                            continue;
                        }
                        if ("fileName".equals(fieldName)) {
                            deserializedFileShareDataset.fileName = reader.readUntyped();
                            continue;
                        }
                        if ("modifiedDatetimeStart".equals(fieldName)) {
                            deserializedFileShareDataset.modifiedDatetimeStart = reader.readUntyped();
                            continue;
                        }
                        if ("modifiedDatetimeEnd".equals(fieldName)) {
                            deserializedFileShareDataset.modifiedDatetimeEnd = reader.readUntyped();
                            continue;
                        }
                        if ("format".equals(fieldName)) {
                            deserializedFileShareDataset.format = DatasetStorageFormat.fromJson(reader);
                            continue;
                        }
                        if ("fileFilter".equals(fieldName)) {
                            deserializedFileShareDataset.fileFilter = reader.readUntyped();
                            continue;
                        }
                        if ("compression".equals(fieldName)) {
                            deserializedFileShareDataset.compression = DatasetCompression.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedFileShareDataset.setAdditionalProperties(additionalProperties);
            return deserializedFileShareDataset;
        });
    }
}

