/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.PipelineReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecutePipelineActivity
extends ControlActivity {
    private String type = "ExecutePipeline";
    private PipelineReference pipeline;
    private Map<String, Object> parameters;
    private Boolean waitOnCompletion;

    @Override
    public String getType() {
        return this.type;
    }

    public PipelineReference getPipeline() {
        return this.pipeline;
    }

    public ExecutePipelineActivity setPipeline(PipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public ExecutePipelineActivity setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean isWaitOnCompletion() {
        return this.waitOnCompletion;
    }

    public ExecutePipelineActivity setWaitOnCompletion(Boolean waitOnCompletion) {
        this.waitOnCompletion = waitOnCompletion;
        return this;
    }

    @Override
    public ExecutePipelineActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ExecutePipelineActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ExecutePipelineActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ExecutePipelineActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecutePipelineActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecutePipelineActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.pipeline != null || this.parameters != null || this.waitOnCompletion != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("pipeline", (JsonSerializable)this.pipeline);
            jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeBooleanField("waitOnCompletion", this.waitOnCompletion);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecutePipelineActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutePipelineActivity)jsonReader.readObject(reader -> {
            ExecutePipelineActivity deserializedExecutePipelineActivity = new ExecutePipelineActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecutePipelineActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecutePipelineActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecutePipelineActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecutePipelineActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecutePipelineActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecutePipelineActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecutePipelineActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("pipeline".equals(fieldName)) {
                            deserializedExecutePipelineActivity.pipeline = PipelineReference.fromJson(reader);
                            continue;
                        }
                        if ("parameters".equals(fieldName)) {
                            Map parameters;
                            deserializedExecutePipelineActivity.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("waitOnCompletion".equals(fieldName)) {
                            deserializedExecutePipelineActivity.waitOnCompletion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecutePipelineActivity.setAdditionalProperties(additionalProperties);
            return deserializedExecutePipelineActivity;
        });
    }
}

