/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ContinuationSettingsReference;
import com.azure.analytics.synapse.artifacts.models.DataFlowReference;
import com.azure.analytics.synapse.artifacts.models.DataFlowStagingInfo;
import com.azure.analytics.synapse.artifacts.models.ExecuteDataFlowActivityTypePropertiesCompute;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecuteDataFlowActivity
extends ExecutionActivity {
    private String type = "ExecuteDataFlow";
    private DataFlowReference dataflow;
    private DataFlowStagingInfo staging;
    private IntegrationRuntimeReference integrationRuntime;
    private ContinuationSettingsReference continuationSettings;
    private ExecuteDataFlowActivityTypePropertiesCompute compute;
    private Object traceLevel;
    private Object continueOnError;
    private Object runConcurrently;
    private Object sourceStagingConcurrency;

    @Override
    public String getType() {
        return this.type;
    }

    public DataFlowReference getDataflow() {
        return this.dataflow;
    }

    public ExecuteDataFlowActivity setDataflow(DataFlowReference dataflow) {
        this.dataflow = dataflow;
        return this;
    }

    public DataFlowStagingInfo getStaging() {
        return this.staging;
    }

    public ExecuteDataFlowActivity setStaging(DataFlowStagingInfo staging) {
        this.staging = staging;
        return this;
    }

    public IntegrationRuntimeReference getIntegrationRuntime() {
        return this.integrationRuntime;
    }

    public ExecuteDataFlowActivity setIntegrationRuntime(IntegrationRuntimeReference integrationRuntime) {
        this.integrationRuntime = integrationRuntime;
        return this;
    }

    public ContinuationSettingsReference getContinuationSettings() {
        return this.continuationSettings;
    }

    public ExecuteDataFlowActivity setContinuationSettings(ContinuationSettingsReference continuationSettings) {
        this.continuationSettings = continuationSettings;
        return this;
    }

    public ExecuteDataFlowActivityTypePropertiesCompute getCompute() {
        return this.compute;
    }

    public ExecuteDataFlowActivity setCompute(ExecuteDataFlowActivityTypePropertiesCompute compute) {
        this.compute = compute;
        return this;
    }

    public Object getTraceLevel() {
        return this.traceLevel;
    }

    public ExecuteDataFlowActivity setTraceLevel(Object traceLevel) {
        this.traceLevel = traceLevel;
        return this;
    }

    public Object getContinueOnError() {
        return this.continueOnError;
    }

    public ExecuteDataFlowActivity setContinueOnError(Object continueOnError) {
        this.continueOnError = continueOnError;
        return this;
    }

    public Object getRunConcurrently() {
        return this.runConcurrently;
    }

    public ExecuteDataFlowActivity setRunConcurrently(Object runConcurrently) {
        this.runConcurrently = runConcurrently;
        return this;
    }

    public Object getSourceStagingConcurrency() {
        return this.sourceStagingConcurrency;
    }

    public ExecuteDataFlowActivity setSourceStagingConcurrency(Object sourceStagingConcurrency) {
        this.sourceStagingConcurrency = sourceStagingConcurrency;
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecuteDataFlowActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.dataflow != null || this.staging != null || this.integrationRuntime != null || this.continuationSettings != null || this.compute != null || this.traceLevel != null || this.continueOnError != null || this.runConcurrently != null || this.sourceStagingConcurrency != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("dataflow", (JsonSerializable)this.dataflow);
            jsonWriter.writeJsonField("staging", (JsonSerializable)this.staging);
            jsonWriter.writeJsonField("integrationRuntime", (JsonSerializable)this.integrationRuntime);
            jsonWriter.writeJsonField("continuationSettings", (JsonSerializable)this.continuationSettings);
            jsonWriter.writeJsonField("compute", (JsonSerializable)this.compute);
            if (this.traceLevel != null) {
                jsonWriter.writeUntypedField("traceLevel", this.traceLevel);
            }
            if (this.continueOnError != null) {
                jsonWriter.writeUntypedField("continueOnError", this.continueOnError);
            }
            if (this.runConcurrently != null) {
                jsonWriter.writeUntypedField("runConcurrently", this.runConcurrently);
            }
            if (this.sourceStagingConcurrency != null) {
                jsonWriter.writeUntypedField("sourceStagingConcurrency", this.sourceStagingConcurrency);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecuteDataFlowActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecuteDataFlowActivity)jsonReader.readObject(reader -> {
            ExecuteDataFlowActivity deserializedExecuteDataFlowActivity = new ExecuteDataFlowActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecuteDataFlowActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecuteDataFlowActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecuteDataFlowActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("dataflow".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.dataflow = DataFlowReference.fromJson(reader);
                            continue;
                        }
                        if ("staging".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.staging = DataFlowStagingInfo.fromJson(reader);
                            continue;
                        }
                        if ("integrationRuntime".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.integrationRuntime = IntegrationRuntimeReference.fromJson(reader);
                            continue;
                        }
                        if ("continuationSettings".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.continuationSettings = ContinuationSettingsReference.fromJson(reader);
                            continue;
                        }
                        if ("compute".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.compute = ExecuteDataFlowActivityTypePropertiesCompute.fromJson(reader);
                            continue;
                        }
                        if ("traceLevel".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.traceLevel = reader.readUntyped();
                            continue;
                        }
                        if ("continueOnError".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.continueOnError = reader.readUntyped();
                            continue;
                        }
                        if ("runConcurrently".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.runConcurrently = reader.readUntyped();
                            continue;
                        }
                        if ("sourceStagingConcurrency".equals(fieldName)) {
                            deserializedExecuteDataFlowActivity.sourceStagingConcurrency = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecuteDataFlowActivity.setAdditionalProperties(additionalProperties);
            return deserializedExecuteDataFlowActivity;
        });
    }
}

