/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DocumentDbCollectionSource
extends CopySource {
    private String type = "DocumentDbCollectionSource";
    private Object query;
    private Object nestingSeparator;
    private Object queryTimeout;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public DocumentDbCollectionSource setQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object getNestingSeparator() {
        return this.nestingSeparator;
    }

    public DocumentDbCollectionSource setNestingSeparator(Object nestingSeparator) {
        this.nestingSeparator = nestingSeparator;
        return this;
    }

    public Object getQueryTimeout() {
        return this.queryTimeout;
    }

    public DocumentDbCollectionSource setQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public DocumentDbCollectionSource setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public DocumentDbCollectionSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public DocumentDbCollectionSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public DocumentDbCollectionSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.nestingSeparator != null) {
            jsonWriter.writeUntypedField("nestingSeparator", this.nestingSeparator);
        }
        if (this.queryTimeout != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DocumentDbCollectionSource fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentDbCollectionSource)jsonReader.readObject(reader -> {
            DocumentDbCollectionSource deserializedDocumentDbCollectionSource = new DocumentDbCollectionSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.query = reader.readUntyped();
                    continue;
                }
                if ("nestingSeparator".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.nestingSeparator = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedDocumentDbCollectionSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDocumentDbCollectionSource.setAdditionalProperties(additionalProperties);
            return deserializedDocumentDbCollectionSource;
        });
    }
}

