/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetLocation;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DelimitedTextDataset
extends Dataset {
    private String type = "DelimitedText";
    private DatasetLocation location;
    private Object columnDelimiter;
    private Object rowDelimiter;
    private Object encodingName;
    private Object compressionCodec;
    private Object compressionLevel;
    private Object quoteChar;
    private Object escapeChar;
    private Object firstRowAsHeader;
    private Object nullValue;

    @Override
    public String getType() {
        return this.type;
    }

    public DatasetLocation getLocation() {
        return this.location;
    }

    public DelimitedTextDataset setLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public DelimitedTextDataset setColumnDelimiter(Object columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        return this;
    }

    public Object getRowDelimiter() {
        return this.rowDelimiter;
    }

    public DelimitedTextDataset setRowDelimiter(Object rowDelimiter) {
        this.rowDelimiter = rowDelimiter;
        return this;
    }

    public Object getEncodingName() {
        return this.encodingName;
    }

    public DelimitedTextDataset setEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    public Object getCompressionCodec() {
        return this.compressionCodec;
    }

    public DelimitedTextDataset setCompressionCodec(Object compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    public Object getCompressionLevel() {
        return this.compressionLevel;
    }

    public DelimitedTextDataset setCompressionLevel(Object compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public Object getQuoteChar() {
        return this.quoteChar;
    }

    public DelimitedTextDataset setQuoteChar(Object quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public Object getEscapeChar() {
        return this.escapeChar;
    }

    public DelimitedTextDataset setEscapeChar(Object escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    public Object getFirstRowAsHeader() {
        return this.firstRowAsHeader;
    }

    public DelimitedTextDataset setFirstRowAsHeader(Object firstRowAsHeader) {
        this.firstRowAsHeader = firstRowAsHeader;
        return this;
    }

    public Object getNullValue() {
        return this.nullValue;
    }

    public DelimitedTextDataset setNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    @Override
    public DelimitedTextDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DelimitedTextDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public DelimitedTextDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public DelimitedTextDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DelimitedTextDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public DelimitedTextDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public DelimitedTextDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.location != null || this.columnDelimiter != null || this.rowDelimiter != null || this.encodingName != null || this.compressionCodec != null || this.compressionLevel != null || this.quoteChar != null || this.escapeChar != null || this.firstRowAsHeader != null || this.nullValue != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
            if (this.columnDelimiter != null) {
                jsonWriter.writeUntypedField("columnDelimiter", this.columnDelimiter);
            }
            if (this.rowDelimiter != null) {
                jsonWriter.writeUntypedField("rowDelimiter", this.rowDelimiter);
            }
            if (this.encodingName != null) {
                jsonWriter.writeUntypedField("encodingName", this.encodingName);
            }
            if (this.compressionCodec != null) {
                jsonWriter.writeUntypedField("compressionCodec", this.compressionCodec);
            }
            if (this.compressionLevel != null) {
                jsonWriter.writeUntypedField("compressionLevel", this.compressionLevel);
            }
            if (this.quoteChar != null) {
                jsonWriter.writeUntypedField("quoteChar", this.quoteChar);
            }
            if (this.escapeChar != null) {
                jsonWriter.writeUntypedField("escapeChar", this.escapeChar);
            }
            if (this.firstRowAsHeader != null) {
                jsonWriter.writeUntypedField("firstRowAsHeader", this.firstRowAsHeader);
            }
            if (this.nullValue != null) {
                jsonWriter.writeUntypedField("nullValue", this.nullValue);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DelimitedTextDataset fromJson(JsonReader jsonReader) throws IOException {
        return (DelimitedTextDataset)jsonReader.readObject(reader -> {
            DelimitedTextDataset deserializedDelimitedTextDataset = new DelimitedTextDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDelimitedTextDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDelimitedTextDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedDelimitedTextDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedDelimitedTextDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedDelimitedTextDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedDelimitedTextDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedDelimitedTextDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDelimitedTextDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("location".equals(fieldName)) {
                            deserializedDelimitedTextDataset.location = DatasetLocation.fromJson(reader);
                            continue;
                        }
                        if ("columnDelimiter".equals(fieldName)) {
                            deserializedDelimitedTextDataset.columnDelimiter = reader.readUntyped();
                            continue;
                        }
                        if ("rowDelimiter".equals(fieldName)) {
                            deserializedDelimitedTextDataset.rowDelimiter = reader.readUntyped();
                            continue;
                        }
                        if ("encodingName".equals(fieldName)) {
                            deserializedDelimitedTextDataset.encodingName = reader.readUntyped();
                            continue;
                        }
                        if ("compressionCodec".equals(fieldName)) {
                            deserializedDelimitedTextDataset.compressionCodec = reader.readUntyped();
                            continue;
                        }
                        if ("compressionLevel".equals(fieldName)) {
                            deserializedDelimitedTextDataset.compressionLevel = reader.readUntyped();
                            continue;
                        }
                        if ("quoteChar".equals(fieldName)) {
                            deserializedDelimitedTextDataset.quoteChar = reader.readUntyped();
                            continue;
                        }
                        if ("escapeChar".equals(fieldName)) {
                            deserializedDelimitedTextDataset.escapeChar = reader.readUntyped();
                            continue;
                        }
                        if ("firstRowAsHeader".equals(fieldName)) {
                            deserializedDelimitedTextDataset.firstRowAsHeader = reader.readUntyped();
                            continue;
                        }
                        if ("nullValue".equals(fieldName)) {
                            deserializedDelimitedTextDataset.nullValue = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDelimitedTextDataset.setAdditionalProperties(additionalProperties);
            return deserializedDelimitedTextDataset;
        });
    }
}

