/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Db2AuthenticationType;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Db2LinkedService
extends LinkedService {
    private String type = "Db2";
    private Object connectionString;
    private Object server;
    private Object database;
    private Db2AuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object packageCollection;
    private Object certificateCommonName;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public Db2LinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getServer() {
        return this.server;
    }

    public Db2LinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public Db2LinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Db2AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public Db2LinkedService setAuthenticationType(Db2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public Db2LinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public Db2LinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getPackageCollection() {
        return this.packageCollection;
    }

    public Db2LinkedService setPackageCollection(Object packageCollection) {
        this.packageCollection = packageCollection;
        return this;
    }

    public Object getCertificateCommonName() {
        return this.certificateCommonName;
    }

    public Db2LinkedService setCertificateCommonName(Object certificateCommonName) {
        this.certificateCommonName = certificateCommonName;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public Db2LinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public Db2LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public Db2LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public Db2LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public Db2LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public Db2LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.server != null || this.database != null || this.authenticationType != null || this.username != null || this.password != null || this.packageCollection != null || this.certificateCommonName != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            jsonWriter.writeUntypedField("server", this.server);
            jsonWriter.writeUntypedField("database", this.database);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.packageCollection != null) {
                jsonWriter.writeUntypedField("packageCollection", this.packageCollection);
            }
            if (this.certificateCommonName != null) {
                jsonWriter.writeUntypedField("certificateCommonName", this.certificateCommonName);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Db2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (Db2LinkedService)jsonReader.readObject(reader -> {
            Db2LinkedService deserializedDb2LinkedService = new Db2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedDb2LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedDb2LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDb2LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedDb2LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedDb2LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDb2LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedDb2LinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("server".equals(fieldName)) {
                            deserializedDb2LinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedDb2LinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedDb2LinkedService.authenticationType = Db2AuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedDb2LinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedDb2LinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("packageCollection".equals(fieldName)) {
                            deserializedDb2LinkedService.packageCollection = reader.readUntyped();
                            continue;
                        }
                        if ("certificateCommonName".equals(fieldName)) {
                            deserializedDb2LinkedService.certificateCommonName = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedDb2LinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDb2LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedDb2LinkedService;
        });
    }
}

