/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DataLakeAnalyticsUsqlActivity
extends ExecutionActivity {
    private String type = "DataLakeAnalyticsU-SQL";
    private Object scriptPath;
    private LinkedServiceReference scriptLinkedService;
    private Object degreeOfParallelism;
    private Object priority;
    private Map<String, Object> parameters;
    private Object runtimeVersion;
    private Object compilationMode;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getScriptPath() {
        return this.scriptPath;
    }

    public DataLakeAnalyticsUsqlActivity setScriptPath(Object scriptPath) {
        this.scriptPath = scriptPath;
        return this;
    }

    public LinkedServiceReference getScriptLinkedService() {
        return this.scriptLinkedService;
    }

    public DataLakeAnalyticsUsqlActivity setScriptLinkedService(LinkedServiceReference scriptLinkedService) {
        this.scriptLinkedService = scriptLinkedService;
        return this;
    }

    public Object getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public DataLakeAnalyticsUsqlActivity setDegreeOfParallelism(Object degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    public Object getPriority() {
        return this.priority;
    }

    public DataLakeAnalyticsUsqlActivity setPriority(Object priority) {
        this.priority = priority;
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public DataLakeAnalyticsUsqlActivity setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Object getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public DataLakeAnalyticsUsqlActivity setRuntimeVersion(Object runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public Object getCompilationMode() {
        return this.compilationMode;
    }

    public DataLakeAnalyticsUsqlActivity setCompilationMode(Object compilationMode) {
        this.compilationMode = compilationMode;
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public DataLakeAnalyticsUsqlActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.scriptPath != null || this.scriptLinkedService != null || this.degreeOfParallelism != null || this.priority != null || this.parameters != null || this.runtimeVersion != null || this.compilationMode != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("scriptPath", this.scriptPath);
            jsonWriter.writeJsonField("scriptLinkedService", (JsonSerializable)this.scriptLinkedService);
            if (this.degreeOfParallelism != null) {
                jsonWriter.writeUntypedField("degreeOfParallelism", this.degreeOfParallelism);
            }
            if (this.priority != null) {
                jsonWriter.writeUntypedField("priority", this.priority);
            }
            jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
            if (this.runtimeVersion != null) {
                jsonWriter.writeUntypedField("runtimeVersion", this.runtimeVersion);
            }
            if (this.compilationMode != null) {
                jsonWriter.writeUntypedField("compilationMode", this.compilationMode);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DataLakeAnalyticsUsqlActivity fromJson(JsonReader jsonReader) throws IOException {
        return (DataLakeAnalyticsUsqlActivity)jsonReader.readObject(reader -> {
            DataLakeAnalyticsUsqlActivity deserializedDataLakeAnalyticsUsqlActivity = new DataLakeAnalyticsUsqlActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedDataLakeAnalyticsUsqlActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedDataLakeAnalyticsUsqlActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataLakeAnalyticsUsqlActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("scriptPath".equals(fieldName)) {
                            deserializedDataLakeAnalyticsUsqlActivity.scriptPath = reader.readUntyped();
                            continue;
                        }
                        if ("scriptLinkedService".equals(fieldName)) {
                            deserializedDataLakeAnalyticsUsqlActivity.scriptLinkedService = LinkedServiceReference.fromJson(reader);
                            continue;
                        }
                        if ("degreeOfParallelism".equals(fieldName)) {
                            deserializedDataLakeAnalyticsUsqlActivity.degreeOfParallelism = reader.readUntyped();
                            continue;
                        }
                        if ("priority".equals(fieldName)) {
                            deserializedDataLakeAnalyticsUsqlActivity.priority = reader.readUntyped();
                            continue;
                        }
                        if ("parameters".equals(fieldName)) {
                            Map parameters;
                            deserializedDataLakeAnalyticsUsqlActivity.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("runtimeVersion".equals(fieldName)) {
                            deserializedDataLakeAnalyticsUsqlActivity.runtimeVersion = reader.readUntyped();
                            continue;
                        }
                        if ("compilationMode".equals(fieldName)) {
                            deserializedDataLakeAnalyticsUsqlActivity.compilationMode = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDataLakeAnalyticsUsqlActivity.setAdditionalProperties(additionalProperties);
            return deserializedDataLakeAnalyticsUsqlActivity;
        });
    }
}

