/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowReferenceType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DataFlowReference
implements JsonSerializable<DataFlowReference> {
    private DataFlowReferenceType type;
    private String referenceName;
    private Object datasetParameters;
    private Map<String, Object> parameters;
    private Map<String, Object> additionalProperties;

    public DataFlowReferenceType getType() {
        return this.type;
    }

    public DataFlowReference setType(DataFlowReferenceType type) {
        this.type = type;
        return this;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public DataFlowReference setReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public Object getDatasetParameters() {
        return this.datasetParameters;
    }

    public DataFlowReference setDatasetParameters(Object datasetParameters) {
        this.datasetParameters = datasetParameters;
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public DataFlowReference setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public DataFlowReference setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("referenceName", this.referenceName);
        if (this.datasetParameters != null) {
            jsonWriter.writeUntypedField("datasetParameters", this.datasetParameters);
        }
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DataFlowReference fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowReference)jsonReader.readObject(reader -> {
            DataFlowReference deserializedDataFlowReference = new DataFlowReference();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDataFlowReference.type = DataFlowReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedDataFlowReference.referenceName = reader.getString();
                    continue;
                }
                if ("datasetParameters".equals(fieldName)) {
                    deserializedDataFlowReference.datasetParameters = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDataFlowReference.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDataFlowReference.additionalProperties = additionalProperties;
            return deserializedDataFlowReference;
        });
    }
}

