/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowSourceSetting;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DataFlowDebugPackageDebugSettings
implements JsonSerializable<DataFlowDebugPackageDebugSettings> {
    private List<DataFlowSourceSetting> sourceSettings;
    private Map<String, Object> parameters;
    private Object datasetParameters;

    public List<DataFlowSourceSetting> getSourceSettings() {
        return this.sourceSettings;
    }

    public DataFlowDebugPackageDebugSettings setSourceSettings(List<DataFlowSourceSetting> sourceSettings) {
        this.sourceSettings = sourceSettings;
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public DataFlowDebugPackageDebugSettings setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Object getDatasetParameters() {
        return this.datasetParameters;
    }

    public DataFlowDebugPackageDebugSettings setDatasetParameters(Object datasetParameters) {
        this.datasetParameters = datasetParameters;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("sourceSettings", this.sourceSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        if (this.datasetParameters != null) {
            jsonWriter.writeUntypedField("datasetParameters", this.datasetParameters);
        }
        return jsonWriter.writeEndObject();
    }

    public static DataFlowDebugPackageDebugSettings fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowDebugPackageDebugSettings)jsonReader.readObject(reader -> {
            DataFlowDebugPackageDebugSettings deserializedDataFlowDebugPackageDebugSettings = new DataFlowDebugPackageDebugSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceSettings".equals(fieldName)) {
                    List sourceSettings;
                    deserializedDataFlowDebugPackageDebugSettings.sourceSettings = sourceSettings = reader.readArray(reader1 -> DataFlowSourceSetting.fromJson(reader1));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedDataFlowDebugPackageDebugSettings.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("datasetParameters".equals(fieldName)) {
                    deserializedDataFlowDebugPackageDebugSettings.datasetParameters = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowDebugPackageDebugSettings;
        });
    }
}

