/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowDebugCommandPayload;
import com.azure.analytics.synapse.artifacts.models.DataFlowDebugCommandType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DataFlowDebugCommandRequest
implements JsonSerializable<DataFlowDebugCommandRequest> {
    private String sessionId;
    private DataFlowDebugCommandType command;
    private DataFlowDebugCommandPayload commandPayload;

    public String getSessionId() {
        return this.sessionId;
    }

    public DataFlowDebugCommandRequest setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public DataFlowDebugCommandType getCommand() {
        return this.command;
    }

    public DataFlowDebugCommandRequest setCommand(DataFlowDebugCommandType command) {
        this.command = command;
        return this;
    }

    public DataFlowDebugCommandPayload getCommandPayload() {
        return this.commandPayload;
    }

    public DataFlowDebugCommandRequest setCommandPayload(DataFlowDebugCommandPayload commandPayload) {
        this.commandPayload = commandPayload;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sessionId", this.sessionId);
        jsonWriter.writeStringField("command", this.command == null ? null : this.command.toString());
        jsonWriter.writeJsonField("commandPayload", (JsonSerializable)this.commandPayload);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowDebugCommandRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowDebugCommandRequest)jsonReader.readObject(reader -> {
            DataFlowDebugCommandRequest deserializedDataFlowDebugCommandRequest = new DataFlowDebugCommandRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sessionId".equals(fieldName)) {
                    deserializedDataFlowDebugCommandRequest.sessionId = reader.getString();
                    continue;
                }
                if ("command".equals(fieldName)) {
                    deserializedDataFlowDebugCommandRequest.command = DataFlowDebugCommandType.fromString(reader.getString());
                    continue;
                }
                if ("commandPayload".equals(fieldName)) {
                    deserializedDataFlowDebugCommandRequest.commandPayload = DataFlowDebugCommandPayload.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowDebugCommandRequest;
        });
    }
}

