/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowFolder;
import com.azure.analytics.synapse.artifacts.models.Flowlet;
import com.azure.analytics.synapse.artifacts.models.MappingDataFlow;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class DataFlow
implements JsonSerializable<DataFlow> {
    private String type = "DataFlow";
    private String description;
    private List<Object> annotations;
    private DataFlowFolder folder;

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public DataFlow setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Object> getAnnotations() {
        return this.annotations;
    }

    public DataFlow setAnnotations(List<Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public DataFlowFolder getFolder() {
        return this.folder;
    }

    public DataFlow setFolder(DataFlowFolder folder) {
        this.folder = folder;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        return jsonWriter.writeEndObject();
    }

    public static DataFlow fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlow)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DataFlow dataFlow;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("MappingDataFlow".equals(discriminatorValue)) {
                    dataFlow = MappingDataFlow.fromJson(readerToUse.reset());
                    return dataFlow;
                }
                if ("Flowlet".equals(discriminatorValue)) {
                    dataFlow = Flowlet.fromJson(readerToUse.reset());
                    return dataFlow;
                }
                dataFlow = DataFlow.fromJsonKnownDiscriminator(readerToUse.reset());
                return dataFlow;
            }
        });
    }

    static DataFlow fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DataFlow)jsonReader.readObject(reader -> {
            DataFlow deserializedDataFlow = new DataFlow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDataFlow.type = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataFlow.description = reader.getString();
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations;
                    deserializedDataFlow.annotations = annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedDataFlow.folder = DataFlowFolder.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlow;
        });
    }
}

