/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CosmosDbLinkedService
extends LinkedService {
    private String type = "CosmosDb";
    private Object connectionString;
    private Object accountEndpoint;
    private Object database;
    private SecretBase accountKey;
    private Object encryptedCredential;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public CosmosDbLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getAccountEndpoint() {
        return this.accountEndpoint;
    }

    public CosmosDbLinkedService setAccountEndpoint(Object accountEndpoint) {
        this.accountEndpoint = accountEndpoint;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public CosmosDbLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public SecretBase getAccountKey() {
        return this.accountKey;
    }

    public CosmosDbLinkedService setAccountKey(SecretBase accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public CosmosDbLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public CosmosDbLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public CosmosDbLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public CosmosDbLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public CosmosDbLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CosmosDbLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public CosmosDbLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.accountEndpoint != null || this.database != null || this.accountKey != null || this.encryptedCredential != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            if (this.accountEndpoint != null) {
                jsonWriter.writeUntypedField("accountEndpoint", this.accountEndpoint);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbLinkedService)jsonReader.readObject(reader -> {
            CosmosDbLinkedService deserializedCosmosDbLinkedService = new CosmosDbLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedCosmosDbLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedCosmosDbLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCosmosDbLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedCosmosDbLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedCosmosDbLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCosmosDbLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedCosmosDbLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("accountEndpoint".equals(fieldName)) {
                            deserializedCosmosDbLinkedService.accountEndpoint = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedCosmosDbLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("accountKey".equals(fieldName)) {
                            deserializedCosmosDbLinkedService.accountKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedCosmosDbLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedCosmosDbLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCosmosDbLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedCosmosDbLinkedService;
        });
    }
}

