/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.LogSettings;
import com.azure.analytics.synapse.artifacts.models.LogStorageSettings;
import com.azure.analytics.synapse.artifacts.models.RedirectIncompatibleRowSettings;
import com.azure.analytics.synapse.artifacts.models.SkipErrorFile;
import com.azure.analytics.synapse.artifacts.models.StagingSettings;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CopyActivity
extends ExecutionActivity {
    private String type = "Copy";
    private List<DatasetReference> inputs;
    private List<DatasetReference> outputs;
    private CopySource source;
    private CopySink sink;
    private Object translator;
    private Object enableStaging;
    private StagingSettings stagingSettings;
    private Object parallelCopies;
    private Object dataIntegrationUnits;
    private Object enableSkipIncompatibleRow;
    private RedirectIncompatibleRowSettings redirectIncompatibleRowSettings;
    private LogStorageSettings logStorageSettings;
    private LogSettings logSettings;
    private List<Object> preserveRules;
    private List<Object> preserve;
    private Object validateDataConsistency;
    private SkipErrorFile skipErrorFile;

    @Override
    public String getType() {
        return this.type;
    }

    public List<DatasetReference> getInputs() {
        return this.inputs;
    }

    public CopyActivity setInputs(List<DatasetReference> inputs) {
        this.inputs = inputs;
        return this;
    }

    public List<DatasetReference> getOutputs() {
        return this.outputs;
    }

    public CopyActivity setOutputs(List<DatasetReference> outputs) {
        this.outputs = outputs;
        return this;
    }

    public CopySource getSource() {
        return this.source;
    }

    public CopyActivity setSource(CopySource source) {
        this.source = source;
        return this;
    }

    public CopySink getSink() {
        return this.sink;
    }

    public CopyActivity setSink(CopySink sink) {
        this.sink = sink;
        return this;
    }

    public Object getTranslator() {
        return this.translator;
    }

    public CopyActivity setTranslator(Object translator) {
        this.translator = translator;
        return this;
    }

    public Object getEnableStaging() {
        return this.enableStaging;
    }

    public CopyActivity setEnableStaging(Object enableStaging) {
        this.enableStaging = enableStaging;
        return this;
    }

    public StagingSettings getStagingSettings() {
        return this.stagingSettings;
    }

    public CopyActivity setStagingSettings(StagingSettings stagingSettings) {
        this.stagingSettings = stagingSettings;
        return this;
    }

    public Object getParallelCopies() {
        return this.parallelCopies;
    }

    public CopyActivity setParallelCopies(Object parallelCopies) {
        this.parallelCopies = parallelCopies;
        return this;
    }

    public Object getDataIntegrationUnits() {
        return this.dataIntegrationUnits;
    }

    public CopyActivity setDataIntegrationUnits(Object dataIntegrationUnits) {
        this.dataIntegrationUnits = dataIntegrationUnits;
        return this;
    }

    public Object getEnableSkipIncompatibleRow() {
        return this.enableSkipIncompatibleRow;
    }

    public CopyActivity setEnableSkipIncompatibleRow(Object enableSkipIncompatibleRow) {
        this.enableSkipIncompatibleRow = enableSkipIncompatibleRow;
        return this;
    }

    public RedirectIncompatibleRowSettings getRedirectIncompatibleRowSettings() {
        return this.redirectIncompatibleRowSettings;
    }

    public CopyActivity setRedirectIncompatibleRowSettings(RedirectIncompatibleRowSettings redirectIncompatibleRowSettings) {
        this.redirectIncompatibleRowSettings = redirectIncompatibleRowSettings;
        return this;
    }

    public LogStorageSettings getLogStorageSettings() {
        return this.logStorageSettings;
    }

    public CopyActivity setLogStorageSettings(LogStorageSettings logStorageSettings) {
        this.logStorageSettings = logStorageSettings;
        return this;
    }

    public LogSettings getLogSettings() {
        return this.logSettings;
    }

    public CopyActivity setLogSettings(LogSettings logSettings) {
        this.logSettings = logSettings;
        return this;
    }

    public List<Object> getPreserveRules() {
        return this.preserveRules;
    }

    public CopyActivity setPreserveRules(List<Object> preserveRules) {
        this.preserveRules = preserveRules;
        return this;
    }

    public List<Object> getPreserve() {
        return this.preserve;
    }

    public CopyActivity setPreserve(List<Object> preserve) {
        this.preserve = preserve;
        return this;
    }

    public Object getValidateDataConsistency() {
        return this.validateDataConsistency;
    }

    public CopyActivity setValidateDataConsistency(Object validateDataConsistency) {
        this.validateDataConsistency = validateDataConsistency;
        return this;
    }

    public SkipErrorFile getSkipErrorFile() {
        return this.skipErrorFile;
    }

    public CopyActivity setSkipErrorFile(SkipErrorFile skipErrorFile) {
        this.skipErrorFile = skipErrorFile;
        return this;
    }

    @Override
    public CopyActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CopyActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public CopyActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public CopyActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public CopyActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public CopyActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public CopyActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public CopyActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeArrayField("inputs", this.inputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.source != null || this.sink != null || this.translator != null || this.enableStaging != null || this.stagingSettings != null || this.parallelCopies != null || this.dataIntegrationUnits != null || this.enableSkipIncompatibleRow != null || this.redirectIncompatibleRowSettings != null || this.logStorageSettings != null || this.logSettings != null || this.preserveRules != null || this.preserve != null || this.validateDataConsistency != null || this.skipErrorFile != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
            jsonWriter.writeJsonField("sink", (JsonSerializable)this.sink);
            if (this.translator != null) {
                jsonWriter.writeUntypedField("translator", this.translator);
            }
            if (this.enableStaging != null) {
                jsonWriter.writeUntypedField("enableStaging", this.enableStaging);
            }
            jsonWriter.writeJsonField("stagingSettings", (JsonSerializable)this.stagingSettings);
            if (this.parallelCopies != null) {
                jsonWriter.writeUntypedField("parallelCopies", this.parallelCopies);
            }
            if (this.dataIntegrationUnits != null) {
                jsonWriter.writeUntypedField("dataIntegrationUnits", this.dataIntegrationUnits);
            }
            if (this.enableSkipIncompatibleRow != null) {
                jsonWriter.writeUntypedField("enableSkipIncompatibleRow", this.enableSkipIncompatibleRow);
            }
            jsonWriter.writeJsonField("redirectIncompatibleRowSettings", (JsonSerializable)this.redirectIncompatibleRowSettings);
            jsonWriter.writeJsonField("logStorageSettings", (JsonSerializable)this.logStorageSettings);
            jsonWriter.writeJsonField("logSettings", (JsonSerializable)this.logSettings);
            jsonWriter.writeArrayField("preserveRules", this.preserveRules, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeArrayField("preserve", this.preserve, (writer, element) -> writer.writeUntyped(element));
            if (this.validateDataConsistency != null) {
                jsonWriter.writeUntypedField("validateDataConsistency", this.validateDataConsistency);
            }
            jsonWriter.writeJsonField("skipErrorFile", (JsonSerializable)this.skipErrorFile);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CopyActivity fromJson(JsonReader jsonReader) throws IOException {
        return (CopyActivity)jsonReader.readObject(reader -> {
            CopyActivity deserializedCopyActivity = new CopyActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCopyActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCopyActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedCopyActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedCopyActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedCopyActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedCopyActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedCopyActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedCopyActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCopyActivity.type = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    List inputs;
                    deserializedCopyActivity.inputs = inputs = reader.readArray(reader1 -> DatasetReference.fromJson(reader1));
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    List outputs;
                    deserializedCopyActivity.outputs = outputs = reader.readArray(reader1 -> DatasetReference.fromJson(reader1));
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("source".equals(fieldName)) {
                            deserializedCopyActivity.source = CopySource.fromJson(reader);
                            continue;
                        }
                        if ("sink".equals(fieldName)) {
                            deserializedCopyActivity.sink = CopySink.fromJson(reader);
                            continue;
                        }
                        if ("translator".equals(fieldName)) {
                            deserializedCopyActivity.translator = reader.readUntyped();
                            continue;
                        }
                        if ("enableStaging".equals(fieldName)) {
                            deserializedCopyActivity.enableStaging = reader.readUntyped();
                            continue;
                        }
                        if ("stagingSettings".equals(fieldName)) {
                            deserializedCopyActivity.stagingSettings = StagingSettings.fromJson(reader);
                            continue;
                        }
                        if ("parallelCopies".equals(fieldName)) {
                            deserializedCopyActivity.parallelCopies = reader.readUntyped();
                            continue;
                        }
                        if ("dataIntegrationUnits".equals(fieldName)) {
                            deserializedCopyActivity.dataIntegrationUnits = reader.readUntyped();
                            continue;
                        }
                        if ("enableSkipIncompatibleRow".equals(fieldName)) {
                            deserializedCopyActivity.enableSkipIncompatibleRow = reader.readUntyped();
                            continue;
                        }
                        if ("redirectIncompatibleRowSettings".equals(fieldName)) {
                            deserializedCopyActivity.redirectIncompatibleRowSettings = RedirectIncompatibleRowSettings.fromJson(reader);
                            continue;
                        }
                        if ("logStorageSettings".equals(fieldName)) {
                            deserializedCopyActivity.logStorageSettings = LogStorageSettings.fromJson(reader);
                            continue;
                        }
                        if ("logSettings".equals(fieldName)) {
                            deserializedCopyActivity.logSettings = LogSettings.fromJson(reader);
                            continue;
                        }
                        if ("preserveRules".equals(fieldName)) {
                            List preserveRules;
                            deserializedCopyActivity.preserveRules = preserveRules = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("preserve".equals(fieldName)) {
                            List preserve;
                            deserializedCopyActivity.preserve = preserve = reader.readArray(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("validateDataConsistency".equals(fieldName)) {
                            deserializedCopyActivity.validateDataConsistency = reader.readUntyped();
                            continue;
                        }
                        if ("skipErrorFile".equals(fieldName)) {
                            deserializedCopyActivity.skipErrorFile = SkipErrorFile.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCopyActivity.setAdditionalProperties(additionalProperties);
            return deserializedCopyActivity;
        });
    }
}

