/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.PipelineReference;
import com.azure.analytics.synapse.artifacts.models.Trigger;
import com.azure.analytics.synapse.artifacts.models.TriggerPipelineReference;
import com.azure.analytics.synapse.artifacts.models.TriggerRuntimeState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChainingTrigger
extends Trigger {
    private String type = "ChainingTrigger";
    private TriggerPipelineReference pipeline;
    private List<PipelineReference> dependsOn;
    private String runDimension;

    @Override
    public String getType() {
        return this.type;
    }

    public TriggerPipelineReference getPipeline() {
        return this.pipeline;
    }

    public ChainingTrigger setPipeline(TriggerPipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public List<PipelineReference> getDependsOn() {
        return this.dependsOn;
    }

    public ChainingTrigger setDependsOn(List<PipelineReference> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public String getRunDimension() {
        return this.runDimension;
    }

    public ChainingTrigger setRunDimension(String runDimension) {
        this.runDimension = runDimension;
        return this;
    }

    @Override
    public ChainingTrigger setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ChainingTrigger setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("pipeline", (JsonSerializable)this.pipeline);
        jsonWriter.writeStringField("type", this.type);
        if (this.dependsOn != null || this.runDimension != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeStringField("runDimension", this.runDimension);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ChainingTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (ChainingTrigger)jsonReader.readObject(reader -> {
            ChainingTrigger deserializedChainingTrigger = new ChainingTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedChainingTrigger.setDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedChainingTrigger.setRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedChainingTrigger.setAnnotations(annotations);
                    continue;
                }
                if ("pipeline".equals(fieldName)) {
                    deserializedChainingTrigger.pipeline = TriggerPipelineReference.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedChainingTrigger.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("dependsOn".equals(fieldName)) {
                            List dependsOn;
                            deserializedChainingTrigger.dependsOn = dependsOn = reader.readArray(reader1 -> PipelineReference.fromJson(reader1));
                            continue;
                        }
                        if ("runDimension".equals(fieldName)) {
                            deserializedChainingTrigger.runDimension = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedChainingTrigger.setAdditionalProperties(additionalProperties);
            return deserializedChainingTrigger;
        });
    }
}

