/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.BlobEventType;
import com.azure.analytics.synapse.artifacts.models.MultiplePipelineTrigger;
import com.azure.analytics.synapse.artifacts.models.TriggerPipelineReference;
import com.azure.analytics.synapse.artifacts.models.TriggerRuntimeState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BlobEventsTrigger
extends MultiplePipelineTrigger {
    private String type = "BlobEventsTrigger";
    private String blobPathBeginsWith;
    private String blobPathEndsWith;
    private Boolean ignoreEmptyBlobs;
    private List<BlobEventType> events;
    private String scope;

    @Override
    public String getType() {
        return this.type;
    }

    public String getBlobPathBeginsWith() {
        return this.blobPathBeginsWith;
    }

    public BlobEventsTrigger setBlobPathBeginsWith(String blobPathBeginsWith) {
        this.blobPathBeginsWith = blobPathBeginsWith;
        return this;
    }

    public String getBlobPathEndsWith() {
        return this.blobPathEndsWith;
    }

    public BlobEventsTrigger setBlobPathEndsWith(String blobPathEndsWith) {
        this.blobPathEndsWith = blobPathEndsWith;
        return this;
    }

    public Boolean isIgnoreEmptyBlobs() {
        return this.ignoreEmptyBlobs;
    }

    public BlobEventsTrigger setIgnoreEmptyBlobs(Boolean ignoreEmptyBlobs) {
        this.ignoreEmptyBlobs = ignoreEmptyBlobs;
        return this;
    }

    public List<BlobEventType> getEvents() {
        return this.events;
    }

    public BlobEventsTrigger setEvents(List<BlobEventType> events) {
        this.events = events;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public BlobEventsTrigger setScope(String scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public BlobEventsTrigger setPipelines(List<TriggerPipelineReference> pipelines) {
        super.setPipelines(pipelines);
        return this;
    }

    @Override
    public BlobEventsTrigger setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public BlobEventsTrigger setAnnotations(List<Object> annotations) {
        super.setAnnotations((List)annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("pipelines", this.getPipelines(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.blobPathBeginsWith != null || this.blobPathEndsWith != null || this.ignoreEmptyBlobs != null || this.events != null || this.scope != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("blobPathBeginsWith", this.blobPathBeginsWith);
            jsonWriter.writeStringField("blobPathEndsWith", this.blobPathEndsWith);
            jsonWriter.writeBooleanField("ignoreEmptyBlobs", this.ignoreEmptyBlobs);
            jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
            jsonWriter.writeStringField("scope", this.scope);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static BlobEventsTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (BlobEventsTrigger)jsonReader.readObject(reader -> {
            BlobEventsTrigger deserializedBlobEventsTrigger = new BlobEventsTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedBlobEventsTrigger.setDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedBlobEventsTrigger.setRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedBlobEventsTrigger.setAnnotations(annotations);
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    deserializedBlobEventsTrigger.setPipelines(pipelines);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobEventsTrigger.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("blobPathBeginsWith".equals(fieldName)) {
                            deserializedBlobEventsTrigger.blobPathBeginsWith = reader.getString();
                            continue;
                        }
                        if ("blobPathEndsWith".equals(fieldName)) {
                            deserializedBlobEventsTrigger.blobPathEndsWith = reader.getString();
                            continue;
                        }
                        if ("ignoreEmptyBlobs".equals(fieldName)) {
                            deserializedBlobEventsTrigger.ignoreEmptyBlobs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("events".equals(fieldName)) {
                            List events;
                            deserializedBlobEventsTrigger.events = events = reader.readArray(reader1 -> BlobEventType.fromString(reader1.getString()));
                            continue;
                        }
                        if ("scope".equals(fieldName)) {
                            deserializedBlobEventsTrigger.scope = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedBlobEventsTrigger.setAdditionalProperties(additionalProperties);
            return deserializedBlobEventsTrigger;
        });
    }
}

