/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureSynapseArtifactsLinkedService
extends LinkedService {
    private String type = "AzureSynapseArtifacts";
    private Object endpoint;
    private Object authentication;
    private Object workspaceResourceId;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public AzureSynapseArtifactsLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object getAuthentication() {
        return this.authentication;
    }

    public AzureSynapseArtifactsLinkedService setAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    public Object getWorkspaceResourceId() {
        return this.workspaceResourceId;
    }

    public AzureSynapseArtifactsLinkedService setWorkspaceResourceId(Object workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    @Override
    public AzureSynapseArtifactsLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureSynapseArtifactsLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureSynapseArtifactsLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureSynapseArtifactsLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureSynapseArtifactsLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.endpoint != null || this.authentication != null || this.workspaceResourceId != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            if (this.authentication != null) {
                jsonWriter.writeUntypedField("authentication", this.authentication);
            }
            if (this.workspaceResourceId != null) {
                jsonWriter.writeUntypedField("workspaceResourceId", this.workspaceResourceId);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSynapseArtifactsLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSynapseArtifactsLinkedService)jsonReader.readObject(reader -> {
            AzureSynapseArtifactsLinkedService deserializedAzureSynapseArtifactsLinkedService = new AzureSynapseArtifactsLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureSynapseArtifactsLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureSynapseArtifactsLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureSynapseArtifactsLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureSynapseArtifactsLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureSynapseArtifactsLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSynapseArtifactsLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("endpoint".equals(fieldName)) {
                            deserializedAzureSynapseArtifactsLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedAzureSynapseArtifactsLinkedService.authentication = reader.readUntyped();
                            continue;
                        }
                        if ("workspaceResourceId".equals(fieldName)) {
                            deserializedAzureSynapseArtifactsLinkedService.workspaceResourceId = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSynapseArtifactsLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureSynapseArtifactsLinkedService;
        });
    }
}

