/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.AzureSqlDatabaseAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.SqlAlwaysEncryptedProperties;
import com.azure.analytics.synapse.artifacts.models.SqlServerBaseLinkedServiceTypeProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureSqlDatabaseLinkedServiceTypeProperties
extends SqlServerBaseLinkedServiceTypeProperties {
    private Object connectionString;
    private AzureSqlDatabaseAuthenticationType authenticationType;
    private Object userName;
    private AzureKeyVaultSecretReference password;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object tenant;
    private Object azureCloudType;
    private SqlAlwaysEncryptedProperties alwaysEncryptedSettings;
    private Object encryptedCredential;
    private CredentialReference credential;

    public Object getConnectionString() {
        return this.connectionString;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureSqlDatabaseAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setAuthenticationType(AzureSqlDatabaseAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public SqlAlwaysEncryptedProperties getAlwaysEncryptedSettings() {
        return this.alwaysEncryptedSettings;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        this.alwaysEncryptedSettings = alwaysEncryptedSettings;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureSqlDatabaseLinkedServiceTypeProperties setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setServer(Object server) {
        super.setServer(server);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setDatabase(Object database) {
        super.setDatabase(database);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setEncrypt(Object encrypt) {
        super.setEncrypt(encrypt);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setTrustServerCertificate(Object trustServerCertificate) {
        super.setTrustServerCertificate(trustServerCertificate);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setHostNameInCertificate(Object hostNameInCertificate) {
        super.setHostNameInCertificate(hostNameInCertificate);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setApplicationIntent(Object applicationIntent) {
        super.setApplicationIntent(applicationIntent);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setConnectTimeout(Object connectTimeout) {
        super.setConnectTimeout(connectTimeout);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setConnectRetryCount(Object connectRetryCount) {
        super.setConnectRetryCount(connectRetryCount);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setConnectRetryInterval(Object connectRetryInterval) {
        super.setConnectRetryInterval(connectRetryInterval);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setLoadBalanceTimeout(Object loadBalanceTimeout) {
        super.setLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setCommandTimeout(Object commandTimeout) {
        super.setCommandTimeout(commandTimeout);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setIntegratedSecurity(Object integratedSecurity) {
        super.setIntegratedSecurity(integratedSecurity);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setFailoverPartner(Object failoverPartner) {
        super.setFailoverPartner(failoverPartner);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setMaxPoolSize(Object maxPoolSize) {
        super.setMaxPoolSize(maxPoolSize);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setMinPoolSize(Object minPoolSize) {
        super.setMinPoolSize(minPoolSize);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setMultipleActiveResultSets(Object multipleActiveResultSets) {
        super.setMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setMultiSubnetFailover(Object multiSubnetFailover) {
        super.setMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setPacketSize(Object packetSize) {
        super.setPacketSize(packetSize);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedServiceTypeProperties setPooling(Object pooling) {
        super.setPooling(pooling);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getServer() != null) {
            jsonWriter.writeUntypedField("server", this.getServer());
        }
        if (this.getDatabase() != null) {
            jsonWriter.writeUntypedField("database", this.getDatabase());
        }
        if (this.getEncrypt() != null) {
            jsonWriter.writeUntypedField("encrypt", this.getEncrypt());
        }
        if (this.getTrustServerCertificate() != null) {
            jsonWriter.writeUntypedField("trustServerCertificate", this.getTrustServerCertificate());
        }
        if (this.getHostNameInCertificate() != null) {
            jsonWriter.writeUntypedField("hostNameInCertificate", this.getHostNameInCertificate());
        }
        if (this.getApplicationIntent() != null) {
            jsonWriter.writeUntypedField("applicationIntent", this.getApplicationIntent());
        }
        if (this.getConnectTimeout() != null) {
            jsonWriter.writeUntypedField("connectTimeout", this.getConnectTimeout());
        }
        if (this.getConnectRetryCount() != null) {
            jsonWriter.writeUntypedField("connectRetryCount", this.getConnectRetryCount());
        }
        if (this.getConnectRetryInterval() != null) {
            jsonWriter.writeUntypedField("connectRetryInterval", this.getConnectRetryInterval());
        }
        if (this.getLoadBalanceTimeout() != null) {
            jsonWriter.writeUntypedField("loadBalanceTimeout", this.getLoadBalanceTimeout());
        }
        if (this.getCommandTimeout() != null) {
            jsonWriter.writeUntypedField("commandTimeout", this.getCommandTimeout());
        }
        if (this.getIntegratedSecurity() != null) {
            jsonWriter.writeUntypedField("integratedSecurity", this.getIntegratedSecurity());
        }
        if (this.getFailoverPartner() != null) {
            jsonWriter.writeUntypedField("failoverPartner", this.getFailoverPartner());
        }
        if (this.getMaxPoolSize() != null) {
            jsonWriter.writeUntypedField("maxPoolSize", this.getMaxPoolSize());
        }
        if (this.getMinPoolSize() != null) {
            jsonWriter.writeUntypedField("minPoolSize", this.getMinPoolSize());
        }
        if (this.getMultipleActiveResultSets() != null) {
            jsonWriter.writeUntypedField("multipleActiveResultSets", this.getMultipleActiveResultSets());
        }
        if (this.getMultiSubnetFailover() != null) {
            jsonWriter.writeUntypedField("multiSubnetFailover", this.getMultiSubnetFailover());
        }
        if (this.getPacketSize() != null) {
            jsonWriter.writeUntypedField("packetSize", this.getPacketSize());
        }
        if (this.getPooling() != null) {
            jsonWriter.writeUntypedField("pooling", this.getPooling());
        }
        if (this.connectionString != null) {
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
        }
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.userName != null) {
            jsonWriter.writeUntypedField("userName", this.userName);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.servicePrincipalCredentialType != null) {
            jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        }
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        if (this.tenant != null) {
            jsonWriter.writeUntypedField("tenant", this.tenant);
        }
        if (this.azureCloudType != null) {
            jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        }
        jsonWriter.writeJsonField("alwaysEncryptedSettings", (JsonSerializable)this.alwaysEncryptedSettings);
        if (this.encryptedCredential != null) {
            jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
        }
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlDatabaseLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlDatabaseLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureSqlDatabaseLinkedServiceTypeProperties deserializedAzureSqlDatabaseLinkedServiceTypeProperties = new AzureSqlDatabaseLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setServer(reader.readUntyped());
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setDatabase(reader.readUntyped());
                    continue;
                }
                if ("encrypt".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setEncrypt(reader.readUntyped());
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setTrustServerCertificate(reader.readUntyped());
                    continue;
                }
                if ("hostNameInCertificate".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setHostNameInCertificate(reader.readUntyped());
                    continue;
                }
                if ("applicationIntent".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setApplicationIntent(reader.readUntyped());
                    continue;
                }
                if ("connectTimeout".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setConnectTimeout(reader.readUntyped());
                    continue;
                }
                if ("connectRetryCount".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setConnectRetryCount(reader.readUntyped());
                    continue;
                }
                if ("connectRetryInterval".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setConnectRetryInterval(reader.readUntyped());
                    continue;
                }
                if ("loadBalanceTimeout".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setLoadBalanceTimeout(reader.readUntyped());
                    continue;
                }
                if ("commandTimeout".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setCommandTimeout(reader.readUntyped());
                    continue;
                }
                if ("integratedSecurity".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setIntegratedSecurity(reader.readUntyped());
                    continue;
                }
                if ("failoverPartner".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setFailoverPartner(reader.readUntyped());
                    continue;
                }
                if ("maxPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setMaxPoolSize(reader.readUntyped());
                    continue;
                }
                if ("minPoolSize".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setMinPoolSize(reader.readUntyped());
                    continue;
                }
                if ("multipleActiveResultSets".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setMultipleActiveResultSets(reader.readUntyped());
                    continue;
                }
                if ("multiSubnetFailover".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setMultiSubnetFailover(reader.readUntyped());
                    continue;
                }
                if ("packetSize".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setPacketSize(reader.readUntyped());
                    continue;
                }
                if ("pooling".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.setPooling(reader.readUntyped());
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.authenticationType = AzureSqlDatabaseAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.userName = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("alwaysEncryptedSettings".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.alwaysEncryptedSettings = SqlAlwaysEncryptedProperties.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.encryptedCredential = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureSqlDatabaseLinkedServiceTypeProperties;
        });
    }
}

