/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.AzureSqlDatabaseAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.SqlAlwaysEncryptedProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureSqlDatabaseLinkedService
extends LinkedService {
    private String type = "AzureSqlDatabase";
    private Object server;
    private Object database;
    private Object encrypt;
    private Object trustServerCertificate;
    private Object hostNameInCertificate;
    private Object applicationIntent;
    private Object connectTimeout;
    private Object connectRetryCount;
    private Object connectRetryInterval;
    private Object loadBalanceTimeout;
    private Object commandTimeout;
    private Object integratedSecurity;
    private Object failoverPartner;
    private Object maxPoolSize;
    private Object minPoolSize;
    private Object multipleActiveResultSets;
    private Object multiSubnetFailover;
    private Object packetSize;
    private Object pooling;
    private Object connectionString;
    private AzureSqlDatabaseAuthenticationType authenticationType;
    private Object userName;
    private AzureKeyVaultSecretReference password;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private Object tenant;
    private Object azureCloudType;
    private SqlAlwaysEncryptedProperties alwaysEncryptedSettings;
    private Object encryptedCredential;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getServer() {
        return this.server;
    }

    public AzureSqlDatabaseLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public AzureSqlDatabaseLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getEncrypt() {
        return this.encrypt;
    }

    public AzureSqlDatabaseLinkedService setEncrypt(Object encrypt) {
        this.encrypt = encrypt;
        return this;
    }

    public Object getTrustServerCertificate() {
        return this.trustServerCertificate;
    }

    public AzureSqlDatabaseLinkedService setTrustServerCertificate(Object trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public Object getHostNameInCertificate() {
        return this.hostNameInCertificate;
    }

    public AzureSqlDatabaseLinkedService setHostNameInCertificate(Object hostNameInCertificate) {
        this.hostNameInCertificate = hostNameInCertificate;
        return this;
    }

    public Object getApplicationIntent() {
        return this.applicationIntent;
    }

    public AzureSqlDatabaseLinkedService setApplicationIntent(Object applicationIntent) {
        this.applicationIntent = applicationIntent;
        return this;
    }

    public Object getConnectTimeout() {
        return this.connectTimeout;
    }

    public AzureSqlDatabaseLinkedService setConnectTimeout(Object connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Object getConnectRetryCount() {
        return this.connectRetryCount;
    }

    public AzureSqlDatabaseLinkedService setConnectRetryCount(Object connectRetryCount) {
        this.connectRetryCount = connectRetryCount;
        return this;
    }

    public Object getConnectRetryInterval() {
        return this.connectRetryInterval;
    }

    public AzureSqlDatabaseLinkedService setConnectRetryInterval(Object connectRetryInterval) {
        this.connectRetryInterval = connectRetryInterval;
        return this;
    }

    public Object getLoadBalanceTimeout() {
        return this.loadBalanceTimeout;
    }

    public AzureSqlDatabaseLinkedService setLoadBalanceTimeout(Object loadBalanceTimeout) {
        this.loadBalanceTimeout = loadBalanceTimeout;
        return this;
    }

    public Object getCommandTimeout() {
        return this.commandTimeout;
    }

    public AzureSqlDatabaseLinkedService setCommandTimeout(Object commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public Object getIntegratedSecurity() {
        return this.integratedSecurity;
    }

    public AzureSqlDatabaseLinkedService setIntegratedSecurity(Object integratedSecurity) {
        this.integratedSecurity = integratedSecurity;
        return this;
    }

    public Object getFailoverPartner() {
        return this.failoverPartner;
    }

    public AzureSqlDatabaseLinkedService setFailoverPartner(Object failoverPartner) {
        this.failoverPartner = failoverPartner;
        return this;
    }

    public Object getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public AzureSqlDatabaseLinkedService setMaxPoolSize(Object maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public Object getMinPoolSize() {
        return this.minPoolSize;
    }

    public AzureSqlDatabaseLinkedService setMinPoolSize(Object minPoolSize) {
        this.minPoolSize = minPoolSize;
        return this;
    }

    public Object getMultipleActiveResultSets() {
        return this.multipleActiveResultSets;
    }

    public AzureSqlDatabaseLinkedService setMultipleActiveResultSets(Object multipleActiveResultSets) {
        this.multipleActiveResultSets = multipleActiveResultSets;
        return this;
    }

    public Object getMultiSubnetFailover() {
        return this.multiSubnetFailover;
    }

    public AzureSqlDatabaseLinkedService setMultiSubnetFailover(Object multiSubnetFailover) {
        this.multiSubnetFailover = multiSubnetFailover;
        return this;
    }

    public Object getPacketSize() {
        return this.packetSize;
    }

    public AzureSqlDatabaseLinkedService setPacketSize(Object packetSize) {
        this.packetSize = packetSize;
        return this;
    }

    public Object getPooling() {
        return this.pooling;
    }

    public AzureSqlDatabaseLinkedService setPooling(Object pooling) {
        this.pooling = pooling;
        return this;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public AzureSqlDatabaseLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureSqlDatabaseAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public AzureSqlDatabaseLinkedService setAuthenticationType(AzureSqlDatabaseAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public AzureSqlDatabaseLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public AzureSqlDatabaseLinkedService setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureSqlDatabaseLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureSqlDatabaseLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public AzureSqlDatabaseLinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public AzureSqlDatabaseLinkedService setServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureSqlDatabaseLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public AzureSqlDatabaseLinkedService setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public SqlAlwaysEncryptedProperties getAlwaysEncryptedSettings() {
        return this.alwaysEncryptedSettings;
    }

    public AzureSqlDatabaseLinkedService setAlwaysEncryptedSettings(SqlAlwaysEncryptedProperties alwaysEncryptedSettings) {
        this.alwaysEncryptedSettings = alwaysEncryptedSettings;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureSqlDatabaseLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureSqlDatabaseLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureSqlDatabaseLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.server != null || this.database != null || this.encrypt != null || this.trustServerCertificate != null || this.hostNameInCertificate != null || this.applicationIntent != null || this.connectTimeout != null || this.connectRetryCount != null || this.connectRetryInterval != null || this.loadBalanceTimeout != null || this.commandTimeout != null || this.integratedSecurity != null || this.failoverPartner != null || this.maxPoolSize != null || this.minPoolSize != null || this.multipleActiveResultSets != null || this.multiSubnetFailover != null || this.packetSize != null || this.pooling != null || this.connectionString != null || this.authenticationType != null || this.userName != null || this.password != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.servicePrincipalCredentialType != null || this.servicePrincipalCredential != null || this.tenant != null || this.azureCloudType != null || this.alwaysEncryptedSettings != null || this.encryptedCredential != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.server != null) {
                jsonWriter.writeUntypedField("server", this.server);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            if (this.encrypt != null) {
                jsonWriter.writeUntypedField("encrypt", this.encrypt);
            }
            if (this.trustServerCertificate != null) {
                jsonWriter.writeUntypedField("trustServerCertificate", this.trustServerCertificate);
            }
            if (this.hostNameInCertificate != null) {
                jsonWriter.writeUntypedField("hostNameInCertificate", this.hostNameInCertificate);
            }
            if (this.applicationIntent != null) {
                jsonWriter.writeUntypedField("applicationIntent", this.applicationIntent);
            }
            if (this.connectTimeout != null) {
                jsonWriter.writeUntypedField("connectTimeout", this.connectTimeout);
            }
            if (this.connectRetryCount != null) {
                jsonWriter.writeUntypedField("connectRetryCount", this.connectRetryCount);
            }
            if (this.connectRetryInterval != null) {
                jsonWriter.writeUntypedField("connectRetryInterval", this.connectRetryInterval);
            }
            if (this.loadBalanceTimeout != null) {
                jsonWriter.writeUntypedField("loadBalanceTimeout", this.loadBalanceTimeout);
            }
            if (this.commandTimeout != null) {
                jsonWriter.writeUntypedField("commandTimeout", this.commandTimeout);
            }
            if (this.integratedSecurity != null) {
                jsonWriter.writeUntypedField("integratedSecurity", this.integratedSecurity);
            }
            if (this.failoverPartner != null) {
                jsonWriter.writeUntypedField("failoverPartner", this.failoverPartner);
            }
            if (this.maxPoolSize != null) {
                jsonWriter.writeUntypedField("maxPoolSize", this.maxPoolSize);
            }
            if (this.minPoolSize != null) {
                jsonWriter.writeUntypedField("minPoolSize", this.minPoolSize);
            }
            if (this.multipleActiveResultSets != null) {
                jsonWriter.writeUntypedField("multipleActiveResultSets", this.multipleActiveResultSets);
            }
            if (this.multiSubnetFailover != null) {
                jsonWriter.writeUntypedField("multiSubnetFailover", this.multiSubnetFailover);
            }
            if (this.packetSize != null) {
                jsonWriter.writeUntypedField("packetSize", this.packetSize);
            }
            if (this.pooling != null) {
                jsonWriter.writeUntypedField("pooling", this.pooling);
            }
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.azureCloudType != null) {
                jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
            }
            jsonWriter.writeJsonField("alwaysEncryptedSettings", (JsonSerializable)this.alwaysEncryptedSettings);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlDatabaseLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlDatabaseLinkedService)jsonReader.readObject(reader -> {
            AzureSqlDatabaseLinkedService deserializedAzureSqlDatabaseLinkedService = new AzureSqlDatabaseLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureSqlDatabaseLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureSqlDatabaseLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSqlDatabaseLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("server".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("encrypt".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.encrypt = reader.readUntyped();
                            continue;
                        }
                        if ("trustServerCertificate".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.trustServerCertificate = reader.readUntyped();
                            continue;
                        }
                        if ("hostNameInCertificate".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.hostNameInCertificate = reader.readUntyped();
                            continue;
                        }
                        if ("applicationIntent".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.applicationIntent = reader.readUntyped();
                            continue;
                        }
                        if ("connectTimeout".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.connectTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("connectRetryCount".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.connectRetryCount = reader.readUntyped();
                            continue;
                        }
                        if ("connectRetryInterval".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.connectRetryInterval = reader.readUntyped();
                            continue;
                        }
                        if ("loadBalanceTimeout".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.loadBalanceTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("commandTimeout".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.commandTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("integratedSecurity".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.integratedSecurity = reader.readUntyped();
                            continue;
                        }
                        if ("failoverPartner".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.failoverPartner = reader.readUntyped();
                            continue;
                        }
                        if ("maxPoolSize".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.maxPoolSize = reader.readUntyped();
                            continue;
                        }
                        if ("minPoolSize".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.minPoolSize = reader.readUntyped();
                            continue;
                        }
                        if ("multipleActiveResultSets".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.multipleActiveResultSets = reader.readUntyped();
                            continue;
                        }
                        if ("multiSubnetFailover".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.multiSubnetFailover = reader.readUntyped();
                            continue;
                        }
                        if ("packetSize".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.packetSize = reader.readUntyped();
                            continue;
                        }
                        if ("pooling".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.pooling = reader.readUntyped();
                            continue;
                        }
                        if ("connectionString".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.authenticationType = AzureSqlDatabaseAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.password = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalCredential".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.servicePrincipalCredential = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("azureCloudType".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.azureCloudType = reader.readUntyped();
                            continue;
                        }
                        if ("alwaysEncryptedSettings".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.alwaysEncryptedSettings = SqlAlwaysEncryptedProperties.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureSqlDatabaseLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSqlDatabaseLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureSqlDatabaseLinkedService;
        });
    }
}

