/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureSearchIndexWriteBehaviorType;
import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureSearchIndexSink
extends CopySink {
    private String type = "AzureSearchIndexSink";
    private AzureSearchIndexWriteBehaviorType writeBehavior;

    @Override
    public String getType() {
        return this.type;
    }

    public AzureSearchIndexWriteBehaviorType getWriteBehavior() {
        return this.writeBehavior;
    }

    public AzureSearchIndexSink setWriteBehavior(AzureSearchIndexWriteBehaviorType writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    @Override
    public AzureSearchIndexSink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public AzureSearchIndexSink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public AzureSearchIndexSink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public AzureSearchIndexSink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public AzureSearchIndexSink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("writeBehavior", this.writeBehavior == null ? null : this.writeBehavior.toString());
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSearchIndexSink fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSearchIndexSink)jsonReader.readObject(reader -> {
            AzureSearchIndexSink deserializedAzureSearchIndexSink = new AzureSearchIndexSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedAzureSearchIndexSink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedAzureSearchIndexSink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedAzureSearchIndexSink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedAzureSearchIndexSink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureSearchIndexSink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSearchIndexSink.type = reader.getString();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedAzureSearchIndexSink.writeBehavior = AzureSearchIndexWriteBehaviorType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSearchIndexSink.setAdditionalProperties(additionalProperties);
            return deserializedAzureSearchIndexSink;
        });
    }
}

