/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.AzureMLWebServiceFile;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureMLBatchExecutionActivity
extends ExecutionActivity {
    private String type = "AzureMLBatchExecution";
    private Map<String, Object> globalParameters;
    private Map<String, AzureMLWebServiceFile> webServiceOutputs;
    private Map<String, AzureMLWebServiceFile> webServiceInputs;

    @Override
    public String getType() {
        return this.type;
    }

    public Map<String, Object> getGlobalParameters() {
        return this.globalParameters;
    }

    public AzureMLBatchExecutionActivity setGlobalParameters(Map<String, Object> globalParameters) {
        this.globalParameters = globalParameters;
        return this;
    }

    public Map<String, AzureMLWebServiceFile> getWebServiceOutputs() {
        return this.webServiceOutputs;
    }

    public AzureMLBatchExecutionActivity setWebServiceOutputs(Map<String, AzureMLWebServiceFile> webServiceOutputs) {
        this.webServiceOutputs = webServiceOutputs;
        return this;
    }

    public Map<String, AzureMLWebServiceFile> getWebServiceInputs() {
        return this.webServiceInputs;
    }

    public AzureMLBatchExecutionActivity setWebServiceInputs(Map<String, AzureMLWebServiceFile> webServiceInputs) {
        this.webServiceInputs = webServiceInputs;
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureMLBatchExecutionActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.globalParameters != null || this.webServiceOutputs != null || this.webServiceInputs != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeMapField("globalParameters", this.globalParameters, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeMapField("webServiceOutputs", this.webServiceOutputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeMapField("webServiceInputs", this.webServiceInputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureMLBatchExecutionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMLBatchExecutionActivity)jsonReader.readObject(reader -> {
            AzureMLBatchExecutionActivity deserializedAzureMLBatchExecutionActivity = new AzureMLBatchExecutionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedAzureMLBatchExecutionActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedAzureMLBatchExecutionActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMLBatchExecutionActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("globalParameters".equals(fieldName)) {
                            Map globalParameters;
                            deserializedAzureMLBatchExecutionActivity.globalParameters = globalParameters = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("webServiceOutputs".equals(fieldName)) {
                            Map webServiceOutputs;
                            deserializedAzureMLBatchExecutionActivity.webServiceOutputs = webServiceOutputs = reader.readMap(reader1 -> AzureMLWebServiceFile.fromJson(reader1));
                            continue;
                        }
                        if ("webServiceInputs".equals(fieldName)) {
                            Map webServiceInputs;
                            deserializedAzureMLBatchExecutionActivity.webServiceInputs = webServiceInputs = reader.readMap(reader1 -> AzureMLWebServiceFile.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureMLBatchExecutionActivity.setAdditionalProperties(additionalProperties);
            return deserializedAzureMLBatchExecutionActivity;
        });
    }
}

