/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureFunctionLinkedService
extends LinkedService {
    private String type = "AzureFunction";
    private Object functionAppUrl;
    private SecretBase functionKey;
    private Object encryptedCredential;
    private CredentialReference credential;
    private Object resourceId;
    private Object authentication;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFunctionAppUrl() {
        return this.functionAppUrl;
    }

    public AzureFunctionLinkedService setFunctionAppUrl(Object functionAppUrl) {
        this.functionAppUrl = functionAppUrl;
        return this;
    }

    public SecretBase getFunctionKey() {
        return this.functionKey;
    }

    public AzureFunctionLinkedService setFunctionKey(SecretBase functionKey) {
        this.functionKey = functionKey;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureFunctionLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureFunctionLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object getResourceId() {
        return this.resourceId;
    }

    public AzureFunctionLinkedService setResourceId(Object resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public Object getAuthentication() {
        return this.authentication;
    }

    public AzureFunctionLinkedService setAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public AzureFunctionLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureFunctionLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureFunctionLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureFunctionLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureFunctionLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.functionAppUrl != null || this.functionKey != null || this.encryptedCredential != null || this.credential != null || this.resourceId != null || this.authentication != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("functionAppUrl", this.functionAppUrl);
            jsonWriter.writeJsonField("functionKey", (JsonSerializable)this.functionKey);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            if (this.resourceId != null) {
                jsonWriter.writeUntypedField("resourceId", this.resourceId);
            }
            if (this.authentication != null) {
                jsonWriter.writeUntypedField("authentication", this.authentication);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionLinkedService)jsonReader.readObject(reader -> {
            AzureFunctionLinkedService deserializedAzureFunctionLinkedService = new AzureFunctionLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureFunctionLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureFunctionLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureFunctionLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureFunctionLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureFunctionLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFunctionLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("functionAppUrl".equals(fieldName)) {
                            deserializedAzureFunctionLinkedService.functionAppUrl = reader.readUntyped();
                            continue;
                        }
                        if ("functionKey".equals(fieldName)) {
                            deserializedAzureFunctionLinkedService.functionKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureFunctionLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureFunctionLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        if ("resourceId".equals(fieldName)) {
                            deserializedAzureFunctionLinkedService.resourceId = reader.readUntyped();
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedAzureFunctionLinkedService.authentication = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureFunctionLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureFunctionLinkedService;
        });
    }
}

