/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.AzureFunctionActivityMethod;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureFunctionActivity
extends ExecutionActivity {
    private String type = "AzureFunctionActivity";
    private AzureFunctionActivityMethod method;
    private Object functionName;
    private Object headers;
    private Object body;

    @Override
    public String getType() {
        return this.type;
    }

    public AzureFunctionActivityMethod getMethod() {
        return this.method;
    }

    public AzureFunctionActivity setMethod(AzureFunctionActivityMethod method) {
        this.method = method;
        return this;
    }

    public Object getFunctionName() {
        return this.functionName;
    }

    public AzureFunctionActivity setFunctionName(Object functionName) {
        this.functionName = functionName;
        return this;
    }

    public Object getHeaders() {
        return this.headers;
    }

    public AzureFunctionActivity setHeaders(Object headers) {
        this.headers = headers;
        return this;
    }

    public Object getBody() {
        return this.body;
    }

    public AzureFunctionActivity setBody(Object body) {
        this.body = body;
        return this;
    }

    @Override
    public AzureFunctionActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureFunctionActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public AzureFunctionActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public AzureFunctionActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureFunctionActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public AzureFunctionActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public AzureFunctionActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public AzureFunctionActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.method != null || this.functionName != null || this.headers != null || this.body != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
            jsonWriter.writeUntypedField("functionName", this.functionName);
            if (this.headers != null) {
                jsonWriter.writeUntypedField("headers", this.headers);
            }
            if (this.body != null) {
                jsonWriter.writeUntypedField("body", this.body);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionActivity)jsonReader.readObject(reader -> {
            AzureFunctionActivity deserializedAzureFunctionActivity = new AzureFunctionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureFunctionActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureFunctionActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedAzureFunctionActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedAzureFunctionActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedAzureFunctionActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedAzureFunctionActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureFunctionActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedAzureFunctionActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFunctionActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("method".equals(fieldName)) {
                            deserializedAzureFunctionActivity.method = AzureFunctionActivityMethod.fromString(reader.getString());
                            continue;
                        }
                        if ("functionName".equals(fieldName)) {
                            deserializedAzureFunctionActivity.functionName = reader.readUntyped();
                            continue;
                        }
                        if ("headers".equals(fieldName)) {
                            deserializedAzureFunctionActivity.headers = reader.readUntyped();
                            continue;
                        }
                        if ("body".equals(fieldName)) {
                            deserializedAzureFunctionActivity.body = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureFunctionActivity.setAdditionalProperties(additionalProperties);
            return deserializedAzureFunctionActivity;
        });
    }
}

