/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.MetadataItem;
import com.azure.analytics.synapse.artifacts.models.StoreWriteSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureFileStorageWriteSettings
extends StoreWriteSettings {
    private String type = "AzureFileStorageWriteSettings";

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public AzureFileStorageWriteSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureFileStorageWriteSettings setCopyBehavior(Object copyBehavior) {
        super.setCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public AzureFileStorageWriteSettings setMetadata(List<MetadataItem> metadata) {
        super.setMetadata(metadata);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getCopyBehavior() != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.getCopyBehavior());
        }
        jsonWriter.writeArrayField("metadata", this.getMetadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFileStorageWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileStorageWriteSettings)jsonReader.readObject(reader -> {
            AzureFileStorageWriteSettings deserializedAzureFileStorageWriteSettings = new AzureFileStorageWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureFileStorageWriteSettings.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedAzureFileStorageWriteSettings.setCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedAzureFileStorageWriteSettings.setMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFileStorageWriteSettings.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureFileStorageWriteSettings.setAdditionalProperties(additionalProperties);
            return deserializedAzureFileStorageWriteSettings;
        });
    }
}

