/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureDatabricksLinkedService
extends LinkedService {
    private String type = "AzureDatabricks";
    private Object domain;
    private SecretBase accessToken;
    private Object authentication;
    private Object workspaceResourceId;
    private Object existingClusterId;
    private Object instancePoolId;
    private Object newClusterVersion;
    private Object newClusterNumOfWorker;
    private Object newClusterNodeType;
    private Map<String, Object> newClusterSparkConf;
    private Map<String, Object> newClusterSparkEnvVars;
    private Map<String, Object> newClusterCustomTags;
    private Object newClusterLogDestination;
    private Object newClusterDriverNodeType;
    private Object newClusterInitScripts;
    private Object newClusterEnableElasticDisk;
    private Object encryptedCredential;
    private Object policyId;
    private CredentialReference credential;
    private Object dataSecurityMode;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getDomain() {
        return this.domain;
    }

    public AzureDatabricksLinkedService setDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public SecretBase getAccessToken() {
        return this.accessToken;
    }

    public AzureDatabricksLinkedService setAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public Object getAuthentication() {
        return this.authentication;
    }

    public AzureDatabricksLinkedService setAuthentication(Object authentication) {
        this.authentication = authentication;
        return this;
    }

    public Object getWorkspaceResourceId() {
        return this.workspaceResourceId;
    }

    public AzureDatabricksLinkedService setWorkspaceResourceId(Object workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    public Object getExistingClusterId() {
        return this.existingClusterId;
    }

    public AzureDatabricksLinkedService setExistingClusterId(Object existingClusterId) {
        this.existingClusterId = existingClusterId;
        return this;
    }

    public Object getInstancePoolId() {
        return this.instancePoolId;
    }

    public AzureDatabricksLinkedService setInstancePoolId(Object instancePoolId) {
        this.instancePoolId = instancePoolId;
        return this;
    }

    public Object getNewClusterVersion() {
        return this.newClusterVersion;
    }

    public AzureDatabricksLinkedService setNewClusterVersion(Object newClusterVersion) {
        this.newClusterVersion = newClusterVersion;
        return this;
    }

    public Object getNewClusterNumOfWorker() {
        return this.newClusterNumOfWorker;
    }

    public AzureDatabricksLinkedService setNewClusterNumOfWorker(Object newClusterNumOfWorker) {
        this.newClusterNumOfWorker = newClusterNumOfWorker;
        return this;
    }

    public Object getNewClusterNodeType() {
        return this.newClusterNodeType;
    }

    public AzureDatabricksLinkedService setNewClusterNodeType(Object newClusterNodeType) {
        this.newClusterNodeType = newClusterNodeType;
        return this;
    }

    public Map<String, Object> getNewClusterSparkConf() {
        return this.newClusterSparkConf;
    }

    public AzureDatabricksLinkedService setNewClusterSparkConf(Map<String, Object> newClusterSparkConf) {
        this.newClusterSparkConf = newClusterSparkConf;
        return this;
    }

    public Map<String, Object> getNewClusterSparkEnvVars() {
        return this.newClusterSparkEnvVars;
    }

    public AzureDatabricksLinkedService setNewClusterSparkEnvVars(Map<String, Object> newClusterSparkEnvVars) {
        this.newClusterSparkEnvVars = newClusterSparkEnvVars;
        return this;
    }

    public Map<String, Object> getNewClusterCustomTags() {
        return this.newClusterCustomTags;
    }

    public AzureDatabricksLinkedService setNewClusterCustomTags(Map<String, Object> newClusterCustomTags) {
        this.newClusterCustomTags = newClusterCustomTags;
        return this;
    }

    public Object getNewClusterLogDestination() {
        return this.newClusterLogDestination;
    }

    public AzureDatabricksLinkedService setNewClusterLogDestination(Object newClusterLogDestination) {
        this.newClusterLogDestination = newClusterLogDestination;
        return this;
    }

    public Object getNewClusterDriverNodeType() {
        return this.newClusterDriverNodeType;
    }

    public AzureDatabricksLinkedService setNewClusterDriverNodeType(Object newClusterDriverNodeType) {
        this.newClusterDriverNodeType = newClusterDriverNodeType;
        return this;
    }

    public Object getNewClusterInitScripts() {
        return this.newClusterInitScripts;
    }

    public AzureDatabricksLinkedService setNewClusterInitScripts(Object newClusterInitScripts) {
        this.newClusterInitScripts = newClusterInitScripts;
        return this;
    }

    public Object getNewClusterEnableElasticDisk() {
        return this.newClusterEnableElasticDisk;
    }

    public AzureDatabricksLinkedService setNewClusterEnableElasticDisk(Object newClusterEnableElasticDisk) {
        this.newClusterEnableElasticDisk = newClusterEnableElasticDisk;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureDatabricksLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getPolicyId() {
        return this.policyId;
    }

    public AzureDatabricksLinkedService setPolicyId(Object policyId) {
        this.policyId = policyId;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureDatabricksLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object getDataSecurityMode() {
        return this.dataSecurityMode;
    }

    public AzureDatabricksLinkedService setDataSecurityMode(Object dataSecurityMode) {
        this.dataSecurityMode = dataSecurityMode;
        return this;
    }

    @Override
    public AzureDatabricksLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureDatabricksLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.domain != null || this.accessToken != null || this.authentication != null || this.workspaceResourceId != null || this.existingClusterId != null || this.instancePoolId != null || this.newClusterVersion != null || this.newClusterNumOfWorker != null || this.newClusterNodeType != null || this.newClusterSparkConf != null || this.newClusterSparkEnvVars != null || this.newClusterCustomTags != null || this.newClusterLogDestination != null || this.newClusterDriverNodeType != null || this.newClusterInitScripts != null || this.newClusterEnableElasticDisk != null || this.encryptedCredential != null || this.policyId != null || this.credential != null || this.dataSecurityMode != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("domain", this.domain);
            jsonWriter.writeJsonField("accessToken", (JsonSerializable)this.accessToken);
            if (this.authentication != null) {
                jsonWriter.writeUntypedField("authentication", this.authentication);
            }
            if (this.workspaceResourceId != null) {
                jsonWriter.writeUntypedField("workspaceResourceId", this.workspaceResourceId);
            }
            if (this.existingClusterId != null) {
                jsonWriter.writeUntypedField("existingClusterId", this.existingClusterId);
            }
            if (this.instancePoolId != null) {
                jsonWriter.writeUntypedField("instancePoolId", this.instancePoolId);
            }
            if (this.newClusterVersion != null) {
                jsonWriter.writeUntypedField("newClusterVersion", this.newClusterVersion);
            }
            if (this.newClusterNumOfWorker != null) {
                jsonWriter.writeUntypedField("newClusterNumOfWorker", this.newClusterNumOfWorker);
            }
            if (this.newClusterNodeType != null) {
                jsonWriter.writeUntypedField("newClusterNodeType", this.newClusterNodeType);
            }
            jsonWriter.writeMapField("newClusterSparkConf", this.newClusterSparkConf, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeMapField("newClusterSparkEnvVars", this.newClusterSparkEnvVars, (writer, element) -> writer.writeUntyped(element));
            jsonWriter.writeMapField("newClusterCustomTags", this.newClusterCustomTags, (writer, element) -> writer.writeUntyped(element));
            if (this.newClusterLogDestination != null) {
                jsonWriter.writeUntypedField("newClusterLogDestination", this.newClusterLogDestination);
            }
            if (this.newClusterDriverNodeType != null) {
                jsonWriter.writeUntypedField("newClusterDriverNodeType", this.newClusterDriverNodeType);
            }
            if (this.newClusterInitScripts != null) {
                jsonWriter.writeUntypedField("newClusterInitScripts", this.newClusterInitScripts);
            }
            if (this.newClusterEnableElasticDisk != null) {
                jsonWriter.writeUntypedField("newClusterEnableElasticDisk", this.newClusterEnableElasticDisk);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.policyId != null) {
                jsonWriter.writeUntypedField("policyId", this.policyId);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            if (this.dataSecurityMode != null) {
                jsonWriter.writeUntypedField("dataSecurityMode", this.dataSecurityMode);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksLinkedService)jsonReader.readObject(reader -> {
            AzureDatabricksLinkedService deserializedAzureDatabricksLinkedService = new AzureDatabricksLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDatabricksLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDatabricksLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("domain".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.domain = reader.readUntyped();
                            continue;
                        }
                        if ("accessToken".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.accessToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("authentication".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.authentication = reader.readUntyped();
                            continue;
                        }
                        if ("workspaceResourceId".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.workspaceResourceId = reader.readUntyped();
                            continue;
                        }
                        if ("existingClusterId".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.existingClusterId = reader.readUntyped();
                            continue;
                        }
                        if ("instancePoolId".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.instancePoolId = reader.readUntyped();
                            continue;
                        }
                        if ("newClusterVersion".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.newClusterVersion = reader.readUntyped();
                            continue;
                        }
                        if ("newClusterNumOfWorker".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.newClusterNumOfWorker = reader.readUntyped();
                            continue;
                        }
                        if ("newClusterNodeType".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.newClusterNodeType = reader.readUntyped();
                            continue;
                        }
                        if ("newClusterSparkConf".equals(fieldName)) {
                            Map newClusterSparkConf;
                            deserializedAzureDatabricksLinkedService.newClusterSparkConf = newClusterSparkConf = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("newClusterSparkEnvVars".equals(fieldName)) {
                            Map newClusterSparkEnvVars;
                            deserializedAzureDatabricksLinkedService.newClusterSparkEnvVars = newClusterSparkEnvVars = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("newClusterCustomTags".equals(fieldName)) {
                            Map newClusterCustomTags;
                            deserializedAzureDatabricksLinkedService.newClusterCustomTags = newClusterCustomTags = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("newClusterLogDestination".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.newClusterLogDestination = reader.readUntyped();
                            continue;
                        }
                        if ("newClusterDriverNodeType".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.newClusterDriverNodeType = reader.readUntyped();
                            continue;
                        }
                        if ("newClusterInitScripts".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.newClusterInitScripts = reader.readUntyped();
                            continue;
                        }
                        if ("newClusterEnableElasticDisk".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.newClusterEnableElasticDisk = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("policyId".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.policyId = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        if ("dataSecurityMode".equals(fieldName)) {
                            deserializedAzureDatabricksLinkedService.dataSecurityMode = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksLinkedService;
        });
    }
}

