/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureDatabricksDeltaLakeDataset
extends Dataset {
    private String type = "AzureDatabricksDeltaLakeDataset";
    private Object table;
    private Object database;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getTable() {
        return this.table;
    }

    public AzureDatabricksDeltaLakeDataset setTable(Object table) {
        this.table = table;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public AzureDatabricksDeltaLakeDataset setDatabase(Object database) {
        this.database = database;
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.table != null || this.database != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.table != null) {
                jsonWriter.writeUntypedField("table", this.table);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDeltaLakeDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDeltaLakeDataset)jsonReader.readObject(reader -> {
            AzureDatabricksDeltaLakeDataset deserializedAzureDatabricksDeltaLakeDataset = new AzureDatabricksDeltaLakeDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDatabricksDeltaLakeDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDatabricksDeltaLakeDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("table".equals(fieldName)) {
                            deserializedAzureDatabricksDeltaLakeDataset.table = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedAzureDatabricksDeltaLakeDataset.database = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksDeltaLakeDataset.setAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksDeltaLakeDataset;
        });
    }
}

