/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetCompression;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureDataLakeStoreDataset
extends Dataset {
    private String type = "AzureDataLakeStoreFile";
    private Object folderPath;
    private Object fileName;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFolderPath() {
        return this.folderPath;
    }

    public AzureDataLakeStoreDataset setFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object getFileName() {
        return this.fileName;
    }

    public AzureDataLakeStoreDataset setFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public DatasetStorageFormat getFormat() {
        return this.format;
    }

    public AzureDataLakeStoreDataset setFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression getCompression() {
        return this.compression;
    }

    public AzureDataLakeStoreDataset setCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public AzureDataLakeStoreDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureDataLakeStoreDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public AzureDataLakeStoreDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public AzureDataLakeStoreDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureDataLakeStoreDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureDataLakeStoreDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public AzureDataLakeStoreDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.folderPath != null || this.fileName != null || this.format != null || this.compression != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.folderPath != null) {
                jsonWriter.writeUntypedField("folderPath", this.folderPath);
            }
            if (this.fileName != null) {
                jsonWriter.writeUntypedField("fileName", this.fileName);
            }
            jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
            jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataLakeStoreDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataLakeStoreDataset)jsonReader.readObject(reader -> {
            AzureDataLakeStoreDataset deserializedAzureDataLakeStoreDataset = new AzureDataLakeStoreDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureDataLakeStoreDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDataLakeStoreDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAzureDataLakeStoreDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAzureDataLakeStoreDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDataLakeStoreDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDataLakeStoreDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAzureDataLakeStoreDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataLakeStoreDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("folderPath".equals(fieldName)) {
                            deserializedAzureDataLakeStoreDataset.folderPath = reader.readUntyped();
                            continue;
                        }
                        if ("fileName".equals(fieldName)) {
                            deserializedAzureDataLakeStoreDataset.fileName = reader.readUntyped();
                            continue;
                        }
                        if ("format".equals(fieldName)) {
                            deserializedAzureDataLakeStoreDataset.format = DatasetStorageFormat.fromJson(reader);
                            continue;
                        }
                        if ("compression".equals(fieldName)) {
                            deserializedAzureDataLakeStoreDataset.compression = DatasetCompression.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataLakeStoreDataset.setAdditionalProperties(additionalProperties);
            return deserializedAzureDataLakeStoreDataset;
        });
    }
}

