/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureDataExplorerSource
extends CopySource {
    private String type = "AzureDataExplorerSource";
    private Object query;
    private Object noTruncation;
    private Object queryTimeout;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getQuery() {
        return this.query;
    }

    public AzureDataExplorerSource setQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object getNoTruncation() {
        return this.noTruncation;
    }

    public AzureDataExplorerSource setNoTruncation(Object noTruncation) {
        this.noTruncation = noTruncation;
        return this;
    }

    public Object getQueryTimeout() {
        return this.queryTimeout;
    }

    public AzureDataExplorerSource setQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public AzureDataExplorerSource setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public AzureDataExplorerSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureDataExplorerSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureDataExplorerSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeUntypedField("query", this.query);
        jsonWriter.writeStringField("type", this.type);
        if (this.noTruncation != null) {
            jsonWriter.writeUntypedField("noTruncation", this.noTruncation);
        }
        if (this.queryTimeout != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataExplorerSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataExplorerSource)jsonReader.readObject(reader -> {
            AzureDataExplorerSource deserializedAzureDataExplorerSource = new AzureDataExplorerSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.query = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.type = reader.getString();
                    continue;
                }
                if ("noTruncation".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.noTruncation = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataExplorerSource.setAdditionalProperties(additionalProperties);
            return deserializedAzureDataExplorerSource;
        });
    }
}

