/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureDataExplorerLinkedService
extends LinkedService {
    private String type = "AzureDataExplorer";
    private Object endpoint;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object database;
    private Object tenant;
    private CredentialReference credential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public AzureDataExplorerLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureDataExplorerLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureDataExplorerLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public AzureDataExplorerLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureDataExplorerLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureDataExplorerLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    @Override
    public AzureDataExplorerLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureDataExplorerLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureDataExplorerLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureDataExplorerLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureDataExplorerLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.endpoint != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.database != null || this.tenant != null || this.credential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            jsonWriter.writeUntypedField("database", this.database);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataExplorerLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataExplorerLinkedService)jsonReader.readObject(reader -> {
            AzureDataExplorerLinkedService deserializedAzureDataExplorerLinkedService = new AzureDataExplorerLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureDataExplorerLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureDataExplorerLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataExplorerLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("endpoint".equals(fieldName)) {
                            deserializedAzureDataExplorerLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzureDataExplorerLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzureDataExplorerLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedAzureDataExplorerLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzureDataExplorerLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureDataExplorerLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataExplorerLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureDataExplorerLinkedService;
        });
    }
}

