/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.MetadataItem;
import com.azure.analytics.synapse.artifacts.models.StoreWriteSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureBlobStorageWriteSettings
extends StoreWriteSettings {
    private String type = "AzureBlobStorageWriteSettings";
    private Object blockSizeInMB;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getBlockSizeInMB() {
        return this.blockSizeInMB;
    }

    public AzureBlobStorageWriteSettings setBlockSizeInMB(Object blockSizeInMB) {
        this.blockSizeInMB = blockSizeInMB;
        return this;
    }

    @Override
    public AzureBlobStorageWriteSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureBlobStorageWriteSettings setCopyBehavior(Object copyBehavior) {
        super.setCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public AzureBlobStorageWriteSettings setMetadata(List<MetadataItem> metadata) {
        super.setMetadata(metadata);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getCopyBehavior() != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.getCopyBehavior());
        }
        jsonWriter.writeArrayField("metadata", this.getMetadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.blockSizeInMB != null) {
            jsonWriter.writeUntypedField("blockSizeInMB", this.blockSizeInMB);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobStorageWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobStorageWriteSettings)jsonReader.readObject(reader -> {
            AzureBlobStorageWriteSettings deserializedAzureBlobStorageWriteSettings = new AzureBlobStorageWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.setCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedAzureBlobStorageWriteSettings.setMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.type = reader.getString();
                    continue;
                }
                if ("blockSizeInMB".equals(fieldName)) {
                    deserializedAzureBlobStorageWriteSettings.blockSizeInMB = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobStorageWriteSettings.setAdditionalProperties(additionalProperties);
            return deserializedAzureBlobStorageWriteSettings;
        });
    }
}

