/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.AzureStorageAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.CredentialReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureBlobStorageLinkedService
extends LinkedService {
    private String type = "AzureBlobStorage";
    private Object connectionString;
    private AzureKeyVaultSecretReference accountKey;
    private Object sasUri;
    private AzureKeyVaultSecretReference sasToken;
    private String serviceEndpoint;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object azureCloudType;
    private String accountKind;
    private String encryptedCredential;
    private CredentialReference credential;
    private AzureStorageAuthenticationType authenticationType;
    private Object containerUri;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public AzureBlobStorageLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference getAccountKey() {
        return this.accountKey;
    }

    public AzureBlobStorageLinkedService setAccountKey(AzureKeyVaultSecretReference accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object getSasUri() {
        return this.sasUri;
    }

    public AzureBlobStorageLinkedService setSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    public AzureKeyVaultSecretReference getSasToken() {
        return this.sasToken;
    }

    public AzureBlobStorageLinkedService setSasToken(AzureKeyVaultSecretReference sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public AzureBlobStorageLinkedService setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureBlobStorageLinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureBlobStorageLinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getTenant() {
        return this.tenant;
    }

    public AzureBlobStorageLinkedService setTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object getAzureCloudType() {
        return this.azureCloudType;
    }

    public AzureBlobStorageLinkedService setAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public String getAccountKind() {
        return this.accountKind;
    }

    public AzureBlobStorageLinkedService setAccountKind(String accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureBlobStorageLinkedService setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference getCredential() {
        return this.credential;
    }

    public AzureBlobStorageLinkedService setCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public AzureStorageAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public AzureBlobStorageLinkedService setAuthenticationType(AzureStorageAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getContainerUri() {
        return this.containerUri;
    }

    public AzureBlobStorageLinkedService setContainerUri(Object containerUri) {
        this.containerUri = containerUri;
        return this;
    }

    @Override
    public AzureBlobStorageLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AzureBlobStorageLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureBlobStorageLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureBlobStorageLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureBlobStorageLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.accountKey != null || this.sasUri != null || this.sasToken != null || this.serviceEndpoint != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.tenant != null || this.azureCloudType != null || this.accountKind != null || this.encryptedCredential != null || this.credential != null || this.authenticationType != null || this.containerUri != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey);
            if (this.sasUri != null) {
                jsonWriter.writeUntypedField("sasUri", this.sasUri);
            }
            jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken);
            jsonWriter.writeStringField("serviceEndpoint", this.serviceEndpoint);
            if (this.servicePrincipalId != null) {
                jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            }
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.tenant != null) {
                jsonWriter.writeUntypedField("tenant", this.tenant);
            }
            if (this.azureCloudType != null) {
                jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
            }
            jsonWriter.writeStringField("accountKind", this.accountKind);
            jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
            jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.containerUri != null) {
                jsonWriter.writeUntypedField("containerUri", this.containerUri);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobStorageLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobStorageLinkedService)jsonReader.readObject(reader -> {
            AzureBlobStorageLinkedService deserializedAzureBlobStorageLinkedService = new AzureBlobStorageLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureBlobStorageLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureBlobStorageLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("accountKey".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.accountKey = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("sasUri".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.sasUri = reader.readUntyped();
                            continue;
                        }
                        if ("sasToken".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.sasToken = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("serviceEndpoint".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.serviceEndpoint = reader.getString();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenant".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.tenant = reader.readUntyped();
                            continue;
                        }
                        if ("azureCloudType".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.azureCloudType = reader.readUntyped();
                            continue;
                        }
                        if ("accountKind".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.accountKind = reader.getString();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.encryptedCredential = reader.getString();
                            continue;
                        }
                        if ("credential".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.credential = CredentialReference.fromJson(reader);
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.authenticationType = AzureStorageAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("containerUri".equals(fieldName)) {
                            deserializedAzureBlobStorageLinkedService.containerUri = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobStorageLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedAzureBlobStorageLinkedService;
        });
    }
}

