/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetCompression;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureBlobFSDataset
extends Dataset {
    private String type = "AzureBlobFSFile";
    private Object folderPath;
    private Object fileName;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFolderPath() {
        return this.folderPath;
    }

    public AzureBlobFSDataset setFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object getFileName() {
        return this.fileName;
    }

    public AzureBlobFSDataset setFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public DatasetStorageFormat getFormat() {
        return this.format;
    }

    public AzureBlobFSDataset setFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression getCompression() {
        return this.compression;
    }

    public AzureBlobFSDataset setCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public AzureBlobFSDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureBlobFSDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public AzureBlobFSDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public AzureBlobFSDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureBlobFSDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureBlobFSDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public AzureBlobFSDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.folderPath != null || this.fileName != null || this.format != null || this.compression != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.folderPath != null) {
                jsonWriter.writeUntypedField("folderPath", this.folderPath);
            }
            if (this.fileName != null) {
                jsonWriter.writeUntypedField("fileName", this.fileName);
            }
            jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
            jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFSDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFSDataset)jsonReader.readObject(reader -> {
            AzureBlobFSDataset deserializedAzureBlobFSDataset = new AzureBlobFSDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureBlobFSDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureBlobFSDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAzureBlobFSDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAzureBlobFSDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureBlobFSDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureBlobFSDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAzureBlobFSDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobFSDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("folderPath".equals(fieldName)) {
                            deserializedAzureBlobFSDataset.folderPath = reader.readUntyped();
                            continue;
                        }
                        if ("fileName".equals(fieldName)) {
                            deserializedAzureBlobFSDataset.fileName = reader.readUntyped();
                            continue;
                        }
                        if ("format".equals(fieldName)) {
                            deserializedAzureBlobFSDataset.format = DatasetStorageFormat.fromJson(reader);
                            continue;
                        }
                        if ("compression".equals(fieldName)) {
                            deserializedAzureBlobFSDataset.compression = DatasetCompression.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobFSDataset.setAdditionalProperties(additionalProperties);
            return deserializedAzureBlobFSDataset;
        });
    }
}

