/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetCompression;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetStorageFormat;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AzureBlobDataset
extends Dataset {
    private String type = "AzureBlob";
    private Object folderPath;
    private Object tableRootLocation;
    private Object fileName;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFolderPath() {
        return this.folderPath;
    }

    public AzureBlobDataset setFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object getTableRootLocation() {
        return this.tableRootLocation;
    }

    public AzureBlobDataset setTableRootLocation(Object tableRootLocation) {
        this.tableRootLocation = tableRootLocation;
        return this;
    }

    public Object getFileName() {
        return this.fileName;
    }

    public AzureBlobDataset setFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public Object getModifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public AzureBlobDataset setModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object getModifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public AzureBlobDataset setModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public DatasetStorageFormat getFormat() {
        return this.format;
    }

    public AzureBlobDataset setFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression getCompression() {
        return this.compression;
    }

    public AzureBlobDataset setCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public AzureBlobDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AzureBlobDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public AzureBlobDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public AzureBlobDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AzureBlobDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AzureBlobDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public AzureBlobDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.folderPath != null || this.tableRootLocation != null || this.fileName != null || this.modifiedDatetimeStart != null || this.modifiedDatetimeEnd != null || this.format != null || this.compression != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.folderPath != null) {
                jsonWriter.writeUntypedField("folderPath", this.folderPath);
            }
            if (this.tableRootLocation != null) {
                jsonWriter.writeUntypedField("tableRootLocation", this.tableRootLocation);
            }
            if (this.fileName != null) {
                jsonWriter.writeUntypedField("fileName", this.fileName);
            }
            if (this.modifiedDatetimeStart != null) {
                jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
            }
            if (this.modifiedDatetimeEnd != null) {
                jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
            }
            jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
            jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobDataset)jsonReader.readObject(reader -> {
            AzureBlobDataset deserializedAzureBlobDataset = new AzureBlobDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAzureBlobDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureBlobDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAzureBlobDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAzureBlobDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureBlobDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureBlobDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAzureBlobDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("folderPath".equals(fieldName)) {
                            deserializedAzureBlobDataset.folderPath = reader.readUntyped();
                            continue;
                        }
                        if ("tableRootLocation".equals(fieldName)) {
                            deserializedAzureBlobDataset.tableRootLocation = reader.readUntyped();
                            continue;
                        }
                        if ("fileName".equals(fieldName)) {
                            deserializedAzureBlobDataset.fileName = reader.readUntyped();
                            continue;
                        }
                        if ("modifiedDatetimeStart".equals(fieldName)) {
                            deserializedAzureBlobDataset.modifiedDatetimeStart = reader.readUntyped();
                            continue;
                        }
                        if ("modifiedDatetimeEnd".equals(fieldName)) {
                            deserializedAzureBlobDataset.modifiedDatetimeEnd = reader.readUntyped();
                            continue;
                        }
                        if ("format".equals(fieldName)) {
                            deserializedAzureBlobDataset.format = DatasetStorageFormat.fromJson(reader);
                            continue;
                        }
                        if ("compression".equals(fieldName)) {
                            deserializedAzureBlobDataset.compression = DatasetCompression.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobDataset.setAdditionalProperties(additionalProperties);
            return deserializedAzureBlobDataset;
        });
    }
}

