/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.DatasetLocation;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AvroDataset
extends Dataset {
    private String type = "Avro";
    private DatasetLocation location;
    private Object avroCompressionCodec;
    private Integer avroCompressionLevel;

    @Override
    public String getType() {
        return this.type;
    }

    public DatasetLocation getLocation() {
        return this.location;
    }

    public AvroDataset setLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object getAvroCompressionCodec() {
        return this.avroCompressionCodec;
    }

    public AvroDataset setAvroCompressionCodec(Object avroCompressionCodec) {
        this.avroCompressionCodec = avroCompressionCodec;
        return this;
    }

    public Integer getAvroCompressionLevel() {
        return this.avroCompressionLevel;
    }

    public AvroDataset setAvroCompressionLevel(Integer avroCompressionLevel) {
        this.avroCompressionLevel = avroCompressionLevel;
        return this;
    }

    @Override
    public AvroDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public AvroDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public AvroDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public AvroDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AvroDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public AvroDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public AvroDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.location != null || this.avroCompressionCodec != null || this.avroCompressionLevel != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
            if (this.avroCompressionCodec != null) {
                jsonWriter.writeUntypedField("avroCompressionCodec", this.avroCompressionCodec);
            }
            jsonWriter.writeNumberField("avroCompressionLevel", (Number)this.avroCompressionLevel);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AvroDataset fromJson(JsonReader jsonReader) throws IOException {
        return (AvroDataset)jsonReader.readObject(reader -> {
            AvroDataset deserializedAvroDataset = new AvroDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAvroDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAvroDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAvroDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAvroDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAvroDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAvroDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAvroDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAvroDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("location".equals(fieldName)) {
                            deserializedAvroDataset.location = DatasetLocation.fromJson(reader);
                            continue;
                        }
                        if ("avroCompressionCodec".equals(fieldName)) {
                            deserializedAvroDataset.avroCompressionCodec = reader.readUntyped();
                            continue;
                        }
                        if ("avroCompressionLevel".equals(fieldName)) {
                            deserializedAvroDataset.avroCompressionLevel = (Integer)reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAvroDataset.setAdditionalProperties(additionalProperties);
            return deserializedAvroDataset;
        });
    }
}

