/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DatasetLocation;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AmazonS3Location
extends DatasetLocation {
    private String type = "AmazonS3Location";
    private Object bucketName;
    private Object version;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getBucketName() {
        return this.bucketName;
    }

    public AmazonS3Location setBucketName(Object bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public Object getVersion() {
        return this.version;
    }

    public AmazonS3Location setVersion(Object version) {
        this.version = version;
        return this;
    }

    @Override
    public AmazonS3Location setFolderPath(Object folderPath) {
        super.setFolderPath(folderPath);
        return this;
    }

    @Override
    public AmazonS3Location setFileName(Object fileName) {
        super.setFileName(fileName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getFolderPath() != null) {
            jsonWriter.writeUntypedField("folderPath", this.getFolderPath());
        }
        if (this.getFileName() != null) {
            jsonWriter.writeUntypedField("fileName", this.getFileName());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.bucketName != null) {
            jsonWriter.writeUntypedField("bucketName", this.bucketName);
        }
        if (this.version != null) {
            jsonWriter.writeUntypedField("version", this.version);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3Location fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3Location)jsonReader.readObject(reader -> {
            AmazonS3Location deserializedAmazonS3Location = new AmazonS3Location();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAmazonS3Location.setFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAmazonS3Location.setFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonS3Location.type = reader.getString();
                    continue;
                }
                if ("bucketName".equals(fieldName)) {
                    deserializedAmazonS3Location.bucketName = reader.readUntyped();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAmazonS3Location.version = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonS3Location.setAdditionalProperties(additionalProperties);
            return deserializedAmazonS3Location;
        });
    }
}

